package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.StrUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrAlertInfoBO;
import com.tydic.dyc.agr.service.agr.bo.AgrDealAgrAlertInfoReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrDealAgrAlertInfoRspBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题：AgrDealAgrAlertInfoServiceImpl
 * 说明：处理协议预警信息服务实现
 * 时间：2024/8/6 14:41
 *
 * @author 周钰焱
 */
@HTServiceImpl
public class AgrDealAgrAlertInfoServiceImpl implements AgrDealAgrAlertInfoService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrDealAgrAlertInfoRspBo dealAgrAlertInfo(AgrDealAgrAlertInfoReqBo reqBo) {
        //查询正在预警中的数据
        AgrAlertInfoBO qryWarningAgrAlertInfoBO = new AgrAlertInfoBO();
        qryWarningAgrAlertInfoBO.setAlertState(AgrCommConstant.AgrAlertStatus.NOT_DEAL);
        List<AgrAlertInfoBO> warningAgrAlertInfoBOList = iAgrAgrModel.qryAgrAlertInfoList(qryWarningAgrAlertInfoBO);
        warningAgrAlertInfoBOList.forEach(warningAgrAlertInfoBO -> {
            warningAgrAlertInfoBO.setAlertState(AgrCommConstant.AgrAlertStatus.TO_BE_DEAL);
        });
        if (CollectionUtils.isNotEmpty(warningAgrAlertInfoBOList)) {
            //更新所有未处理的数据为处理中
            this.iAgrAgrModel.updateAgrAlertStatus(warningAgrAlertInfoBOList);
        }
        List<String> warningAgrIds
                = warningAgrAlertInfoBOList.stream().map(AgrAlertInfoBO::getObjId).distinct().collect(Collectors.toList());
        // 将 List<Long> 转换为 List<String>
        List<String> agrIdsAsString = reqBo.getAgrIds().stream().map(Object::toString).collect(Collectors.toList());

        //需要新增的预警数据集合
        List<String> notInWarningAgrIds = agrIdsAsString.stream().filter(id -> !warningAgrIds.contains(id)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notInWarningAgrIds)) {
            List<Long> insertAgrIds = notInWarningAgrIds.stream().map(Long::parseLong).collect(Collectors.toList());
            //查询新增的协议信息
            AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
            agrAgrQryBo.setAgrIds(insertAgrIds);
            agrAgrQryBo.setPageNo(-1);
            agrAgrQryBo.setPageSize(-1);
            AgrGetAgrMainListRspQryBo agrMainList = iAgrAgrModel.getAgrMainList(agrAgrQryBo);
            Map<Long, AgrAgrDo> agrMap = agrMainList.getRows().stream().collect(Collectors.toMap(AgrAgrDo::getAgrId, agrAgrDo -> agrAgrDo, (k1, k2) -> k1));
            List<AgrAlertInfoBO> newAgrAlertInfoBOList = new ArrayList<>(notInWarningAgrIds.size());
            for (String agrId : notInWarningAgrIds) {
                AgrAgrDo agrAgrDo = agrMap.get(Long.parseLong(agrId));
                AgrAlertInfoBO agrAlertInfoBO = new AgrAlertInfoBO();
                agrAlertInfoBO.setObjId(agrId);
                agrAlertInfoBO.setObjType(AgrCommConstant.AgrAlertType.EXPIRE);
                agrAlertInfoBO.setAlertType(AgrCommConstant.AgrAlertType.EXPIRE);
                agrAlertInfoBO.setCreateTime(new Date());
                agrAlertInfoBO.setAlertState(AgrCommConstant.AgrAlertStatus.NOT_DEAL);
                agrAlertInfoBO.setCreateUserId(agrAgrDo.getUpdateLoginId());
                if (StrUtil.isNotEmpty(agrAgrDo.getCreateCompanyIds())) {
                    String[] split = agrAgrDo.getCreateCompanyIds().split(",");
                    agrAlertInfoBO.setCreateOrgId(Long.parseLong(split[0]));
                    agrAlertInfoBO.setCreateCompanyId(Long.parseLong(split[0]));
                }
                if (StrUtil.isNotEmpty(agrAgrDo.getCreateCompanyNames())) {
                    String[] split = agrAgrDo.getCreateCompanyNames().split(",");
                    agrAlertInfoBO.setCreateOrgName(split[0]);
                    agrAlertInfoBO.setCreateCompanyName(split[0]);
                }
                if (StrUtil.isNotEmpty(agrAgrDo.getCreateOrgTreePaths())) {
                    String[] split = agrAgrDo.getCreateOrgTreePaths().split(",");
                    agrAlertInfoBO.setCreateOrgPath(split[0]);
                }
                newAgrAlertInfoBOList.add(agrAlertInfoBO);
            }
            this.iAgrAgrModel.createAgrAlertInfo(newAgrAlertInfoBOList);
        }
        //继续预警的预警数据
        List<String> keepWarningAgrIds = agrIdsAsString.stream().filter(warningAgrIds::contains).collect(Collectors.toList());

        if (CollectionUtils.isNotEmpty(keepWarningAgrIds)) {
            List<AgrAlertInfoBO> keepWarningAgrBOList = new ArrayList<>(keepWarningAgrIds.size());
            for (String keepWarningAgrId : keepWarningAgrIds) {
                AgrAlertInfoBO agrAlertInfoBO = new AgrAlertInfoBO();
                agrAlertInfoBO.setObjId(keepWarningAgrId);
                agrAlertInfoBO.setAlertState(AgrCommConstant.AgrAlertStatus.NOT_DEAL);
                keepWarningAgrBOList.add(agrAlertInfoBO);
            }
            this.iAgrAgrModel.updateAgrAlertInfo(keepWarningAgrBOList);
        }
        //不在预警范围内的数据置为已处理
        List<String> notInAgrIds = warningAgrIds.stream().filter(id -> !agrIdsAsString.contains(id)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notInAgrIds)) {
            List<AgrAlertInfoBO> dealedAgrBOList = new ArrayList<>(notInAgrIds.size());
            for (String dealedAgrId : notInAgrIds) {
                AgrAlertInfoBO agrAlertInfoBO = new AgrAlertInfoBO();
                agrAlertInfoBO.setObjId(dealedAgrId);
                agrAlertInfoBO.setAlertState(AgrCommConstant.AgrAlertStatus.DEALED);
                dealedAgrBOList.add(agrAlertInfoBO);
            }
            this.iAgrAgrModel.updateAgrAlertInfo(dealedAgrBOList);
        }

        return AgrRu.success(AgrDealAgrAlertInfoRspBo.class);
    }
}
