package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrItemDetailBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @title: AgrGetAgrItemListServiceImpl
 * @describe： 协议明细列表查询服务实现
 * @created: 2022/8/30 14:12
 * @author: FKC
 */
@Slf4j
@HTServiceImpl
public class AgrGetAgrItemListServiceImpl implements AgrGetAgrItemListService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;

    @Override
    public AgrGetAgrItemListRspBO getAgrItemList(AgrGetAgrItemListReqBO reqBO) {
        //1 组装入参
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = AgrRu.js(reqBO, AgrItemListQryReqPageBo.class);
        //2 调用协议明细列表查询方法
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);

        List<Long> agrIds = agrItemListQryRspPageBo.getRows().stream().map(AgrItem::getAgrId).distinct().collect(Collectors.toList());

        Map<Long, AgrAgrDo> agrMap = new HashMap<>(agrIds.size());
        //查询协议主体信息
        if (CollectionUtil.isNotEmpty(agrIds)) {
            AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
            agrAgrQryBo.setAgrIds(agrIds);
            agrAgrQryBo.setPageNo(-1);
            agrAgrQryBo.setPageSize(-1);
            AgrGetAgrMainListRspQryBo agrMainList = iAgrAgrModel.getAgrMainList(agrAgrQryBo);
            agrMap = agrMainList.getRows().stream().collect(Collectors.toMap(AgrAgrDo::getAgrId, agrAgrDo -> agrAgrDo, (k1, k2) -> k1));
        }
        //3 组装出参
        AgrGetAgrItemListRspBO rspBO = JSONObject.parseObject(JSONObject.toJSONString(agrItemListQryRspPageBo), AgrGetAgrItemListRspBO.class);
        //4 翻译转义
        List<String> pCodeList = new ArrayList<>();
        pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_CONTROL_PCODE);
        pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_PRICE_ADJUST_PCODE);
        pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_STATUS_PCODE);
        pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_SUPERMARKET);
        pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_CENTRALIZED_PURCHASING);
        pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_PUR_TYPE);
        Map<String, Map<String, DicDictionaryBo>> dicMap = this.iAgrDictionaryModel.selectByPCodeListToMap(pCodeList);
        this.translation(rspBO, dicMap, agrMap);
        log.debug("协议明细列表查询结果：{}", JSONObject.toJSONString(rspBO));
        return rspBO;
    }

    /**
     * 翻译
     *
     * @param rspBO 入参
     */
    private void translation(AgrGetAgrItemListRspBO rspBO, Map<String, Map<String, DicDictionaryBo>> dicMap, Map<Long, AgrAgrDo> agrMap) {
        if (rspBO != null) {
            List<AgrItemDetailBo> rows = rspBO.getRows();
            if (!CollectionUtils.isEmpty(rows)) {
                rows.forEach(x -> {
                            if (agrMap.containsKey(x.getAgrId())) {
                                x.setAgrCode(agrMap.get(x.getAgrId()).getAgrCode());
                                x.setPurType(agrMap.get(x.getAgrId()).getPurType());
                                if (x.getPurType() != null) {
                                    x.setPurTypeStr(
                                            MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_PUR_TYPE)) ? null :
                                                    dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_PUR_TYPE).get(x.getPurType().toString()).getTitle());
                                }
                            }
                            Integer whetherOil = x.getWhetherOil();
                            if (whetherOil != null) {
                                x.setWhetherOilStr(AgrCommConstant.IsOilPcodeEnum.getValueByCode(whetherOil));
                            }
                            if (x.getIsControlPurchaseNum() != null) {
                                x.setIsControlPurchaseNumStr(
                                        MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_CONTROL_PCODE)) ? null :
                                                dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_CONTROL_PCODE).get(x.getIsControlPurchaseNum().toString()).getTitle());
                            }
                            if (x.getIsPriceAdjust() != null) {
                                x.setIsPriceAdjustStr(
                                        MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_PRICE_ADJUST_PCODE)) ? null :
                                                dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_PRICE_ADJUST_PCODE).get(x.getIsPriceAdjust().toString()).getTitle());
                            }
                            if (x.getAgrItemStatus() != null) {
                                x.setAgrItemStatusStr(
                                        MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_STATUS_PCODE)) ? null :
                                                dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_STATUS_PCODE).get(x.getAgrItemStatus().toString()).getTitle());
                            }
                            if (x.getIsSupermarket() != null) {
                                x.setIsSupermarketStr(
                                        MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_SUPERMARKET)) ? null :
                                                dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_SUPERMARKET).get(x.getIsSupermarket().toString()).getTitle());
                            }
                            if (x.getIsCentralizedPurchasing() != null) {
                                x.setIsCentralizedPurchasingStr(
                                        MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_CENTRALIZED_PURCHASING)) ? null :
                                                dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_CENTRALIZED_PURCHASING).get(x.getIsCentralizedPurchasing().toString()).getTitle());
                            }
                            if (StrUtil.isNotBlank(x.getPurchaseOrgTreePath())) {
                                x.setPurchaseOrgTreePaths(Arrays.asList(x.getPurchaseOrgTreePath().split(",")));
                            }
                        }
                );
            }
        }
    }
}
