package com.tydic.dyc.agr.service.agr;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.service.agr.bo.AgrAlertInfoBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAlertListReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrAlertListRspBo;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：AgrQryAgrAlertInfoListImpl
 * 说明：
 * 时间： 2024-08-12 16:47
 * 作者 @author LY
 */
@HTServiceImpl
public class AgrQryAgrAlertInfoListImpl implements AgrQryAgrAlertInfoList {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrAlertListRspBo qryAgrAlertInfoList(AgrAlertListReqBo reqBo) {
        AgrAlertInfoBO agrAlertInfoBO = JSON.parseObject(JSON.toJSONString(reqBo), AgrAlertInfoBO.class);
        List<AgrAlertInfoBO> warningAgrAlertInfoBOList = iAgrAgrModel.qryAgrAlertInfoList(agrAlertInfoBO);
        AgrAlertListRspBo rspBo = new AgrAlertListRspBo();
        rspBo.setRows(JSON.parseArray(JSON.toJSONString(warningAgrAlertInfoBOList), AgrAlertInfoBO.class));
        rspBo.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(AgrRspConstant.RESP_DESC_SUCCESS);
        return rspBo;
    }
}
