package com.tydic.dyc.agr.service.agrchange;

import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.sub.AgrItemChng;
import com.tydic.dyc.agr.service.agrchange.bo.AgrUpdateAgrChngItemSpecifyFieldReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrUpdateAgrChngItemSpecifyFieldRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:AgrUpdateAgrChngItemSpecifyFieldServiceImpl
 * 说明:TODO
 * 时间:2023/4/23 19:56
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrUpdateAgrChngItemSpecifyFieldServiceImpl implements AgrUpdateAgrChngItemSpecifyFieldService {
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Override
    public AgrUpdateAgrChngItemSpecifyFieldRspBO updateAgrChngItemSpecifyField(AgrUpdateAgrChngItemSpecifyFieldReqBO agrUpdateAgrChngItemSpecifyFieldReqBO) {
        if(agrUpdateAgrChngItemSpecifyFieldReqBO.getAgrId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "协议ID不能为空");
        }
        if(agrUpdateAgrChngItemSpecifyFieldReqBO.getChngApplyId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "变更申请ID不能为空");
        }
        AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
        agrChngApplyDo.setAgrId(agrUpdateAgrChngItemSpecifyFieldReqBO.getAgrId());
        agrChngApplyDo.setChngApplyId(agrUpdateAgrChngItemSpecifyFieldReqBO.getChngApplyId());
        agrChngApplyDo.setUpdateRange(agrUpdateAgrChngItemSpecifyFieldReqBO.getUpdateRange());
        List<AgrItemChng> agrItemChng = new ArrayList<>();
        AgrItemChng bo = AgrRu.js(agrUpdateAgrChngItemSpecifyFieldReqBO,AgrItemChng.class);
        agrItemChng.add(bo);
        agrChngApplyDo.setAgrItemChng(agrItemChng);
        this.iAgrChngApplyModel.updateAgrChngItemSpecifyField(agrChngApplyDo);
        return AgrRu.success(AgrUpdateAgrChngItemSpecifyFieldRspBO.class);
    }
}
