package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.service.agrchange.bo.AgrUpdateArgChngApplyReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrUpdateArgChngApplyRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * @title: AgrUpdateArgChngApplyServiceImpl
 * @describe： 协议变更申请修改服务实现
 * @created: 2022/9/9 14:55
 * @author: FKC
 */
@HTServiceImpl
@Slf4j
public class AgrUpdateArgChngApplyServiceImpl implements AgrUpdateArgChngApplyService{
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @Override
    public AgrUpdateArgChngApplyRspBO updateAgrChngApply(AgrUpdateArgChngApplyReqBO agrUpdateArgChngApplyReqBO) {
        //1 入参校验
        this.val(agrUpdateArgChngApplyReqBO);
        //2 组装协议变更申请入参
        AgrChngApplyDo agrChngApplyDo = JSONObject.parseObject(JSONObject.toJSONString(agrUpdateArgChngApplyReqBO),AgrChngApplyDo.class);
        log.debug("组装协议变更申请入参[agrChngApplyDo]:{}",agrChngApplyDo);
        //3 协议变更申请修改
        this.iAgrChngApplyModel.updateAgrChngApply(agrChngApplyDo);
        return  AgrRu.success(AgrUpdateArgChngApplyRspBO.class);
    }

    /**
     * 入参校验
     */
    private void val(AgrUpdateArgChngApplyReqBO agrUpdateArgChngApplyReqBO) {
        if (ObjectUtil.isEmpty(agrUpdateArgChngApplyReqBO)) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgChngApplyReqBO.getChngApplyId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请ID]不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgChngApplyReqBO.getChngApplyNo())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请编号]不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgChngApplyReqBO.getChngType())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议变更类型]不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgChngApplyReqBO.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgChngApplyReqBO.getAgrCode())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议编号]不能为空");
        }
        if (ObjectUtil.isEmpty(agrUpdateArgChngApplyReqBO.getAgrVersion())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议版本]不能为空");
        }
        if (!CollectionUtils.isEmpty(agrUpdateArgChngApplyReqBO.getAgrChngAccessory())) {
            agrUpdateArgChngApplyReqBO.getAgrChngAccessory().forEach(agrChngAccessory -> {
                if (ObjectUtil.isEmpty(agrChngAccessory.getAttachmentType())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更附件附件类型]不能为空");
                }
                if (ObjectUtil.isEmpty(agrChngAccessory.getAccessoryName())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更附件附件名称]不能为空");
                }
                if (ObjectUtil.isEmpty(agrChngAccessory.getAccessoryUrl())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更附件附件url]不能为空");
                }
            });
        }
    }
}
