package com.tydic.dyc.agr.service.auditorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.service.auditorder.bo.AgrGetAuditToDoInfoReqBO;
import com.tydic.dyc.agr.service.auditorder.bo.AgrGetAuditToDoInfoRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description: AgrGetAuditToDoInfoServiceImpl
 * @Author: the_xhl
 * @Date: 2023-10-24
 */
@HTServiceImpl
public class AgrGetAuditToDoInfoServiceImpl implements AgrGetAuditToDoInfoService {

    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;

    @Override
    public AgrGetAuditToDoInfoRspBO getAuditToDoInfo(AgrGetAuditToDoInfoReqBO reqBO) {
        check(reqBO);
        AgrGetAuditToDoInfoRspBO rspBO = this.iAgrAuditOrderModel.getAuditTodoInfo(reqBO);
        rspBO.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(AgrRspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    private void check(AgrGetAuditToDoInfoReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO.getObjId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[objId]不能为空");
        }
        if (ObjectUtil.isNull(reqBO.getUserId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[userId]不能为空");
        }
        if (ObjectUtil.isNull(reqBO.getObjType())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[objType]不能为空");
        }
    }
}
