package com.tydic.dyc.agr.service.procinst;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderProcInst;
import com.tydic.dyc.agr.service.procinst.bo.AgrUpdateProcInstReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrUpdateProcInstRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: AgrUpdateProcInstServiceImpl
 * @Author: the_xhl
 * @Date: 2023-08-14
 */
@HTServiceImpl
public class AgrUpdateProcInstServiceImpl implements AgrUpdateProcInstService {

    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;

    @Override
    public AgrUpdateProcInstRspBO updateProcInst(AgrUpdateProcInstReqBO reqBO) {
        this.check(reqBO);
        AgrUpdateProcInstRspBO rspBO = AgrRu.success(AgrUpdateProcInstRspBO.class);
        List<UocOrderProcInst> uocOrderProcInstList = reqBO.getProcInstIdList().stream().map(e -> {
            UocOrderProcInst uocOrderProcInst = new UocOrderProcInst();
            uocOrderProcInst.setProcInstId(e);
            return uocOrderProcInst;
        }).collect(Collectors.toList());
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        agrProcInstDo.setFinishTag(reqBO.getFinishTag());
        agrProcInstDo.setAgrUocOrderProcInst(uocOrderProcInstList);
        this.iAgrProcInstModel.updateProcInst(agrProcInstDo);
        return rspBO;
    }

    private void check(AgrUpdateProcInstReqBO reqBO) {
        if (CollectionUtil.isEmpty(reqBO.getProcInstIdList())) {
            throw new BaseBusinessException("", "入参对象属性[流程实例ID集合]不能为空");
        }
        if (ObjectUtil.isNull(reqBO.getFinishTag())) {
            throw new BaseBusinessException("", "入参对象属性[finishTag]不能为空");
        }
    }
}
