package com.tydic.dyc.agr.service.sysdictionary;

import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.SysDicDictionaryDo;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.sysdictionary.AgrAddDictionaryService;
import com.tydic.dyc.agr.service.sysdictionary.bo.AgrAddDictionaryReqBo;
import com.tydic.dyc.agr.service.sysdictionary.bo.AgrAddDictionaryRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：AgrAddDictionaryServiceiMPL
 * 说明：
 * 时间：2022/7/6 16:14
 * 作者：huzhongbao
 */
@HTServiceImpl
@Slf4j
public class AgrAddDictionaryServiceImpl implements AgrAddDictionaryService {
    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;
    @Override
    public AgrAddDictionaryRspBo addDicDictionary(AgrAddDictionaryReqBo reqBo) {
        validationParamsInvoice(reqBo);
        AgrAddDictionaryRspBo dictionaryAbilityRspBO = new AgrAddDictionaryRspBo();
        dictionaryAbilityRspBO.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        dictionaryAbilityRspBO.setRespDesc("成功");
        /**
         * 校验字典是否存在
         */
        SysDicDictionaryDo sysDicDictionaryDo = new SysDicDictionaryDo();
        sysDicDictionaryDo.setPCode(reqBo.getPCode());
        sysDicDictionaryDo.setCode(reqBo.getCode());
        SysDicDictionaryDo dicDictionaryDo = this.iAgrDictionaryModel.getDictionaryByDo(sysDicDictionaryDo);
        if (null == dicDictionaryDo){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_DATA_EXIST, "该字典编码已经存在");
        }
        BeanUtils.copyProperties(reqBo,sysDicDictionaryDo);
        this.iAgrDictionaryModel.addDicDictionary(sysDicDictionaryDo);
        return dictionaryAbilityRspBO;
    }
    /**
     * 入参校验
     *
     * @param  reqBO
     */
    private void validationParamsInvoice(AgrAddDictionaryReqBo reqBO){
        if(StringUtils.isEmpty(reqBO.getPCode())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "字典服务入参[pcode]参数不能为空");
        }
        if(StringUtils.isEmpty(reqBO.getCode())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "字典服务入参[code]参数不能为空");
        }
    }
}
