/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.bo.AgrItemBo;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListByOrgIdService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListByOrgIdReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListByOrgIdRspBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrGetAgrItemListByOrgIdService"})
public class AgrGetAgrItemListByOrgIdServiceImpl
implements AgrGetAgrItemListByOrgIdService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;

    @PostMapping(value={"getAgrItemListByOrgId"})
    public AgrGetAgrItemListByOrgIdRspBo getAgrItemListByOrgId(@RequestBody AgrGetAgrItemListByOrgIdReqBo reqBo) {
        AgrGetAgrItemListByOrgIdRspBo rspBo = new AgrGetAgrItemListByOrgIdRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        this.virifyReq(reqBo);
        ArrayList<String> scopeCodes = new ArrayList();
        if (!ObjectUtil.isEmpty((Object)reqBo.getPurOrgPath())) {
            scopeCodes = Arrays.asList(reqBo.getPurOrgPath().split("-"));
        }
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setScopeCodes(scopeCodes);
        agrAgrQryBo.setAgrType(AgrCommConstant.AgrType.AGR);
        List<AgrAppScope> otherAgrAppScopes = this.iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo);
        AgrAgrQryBo agrAgrQryBo1 = new AgrAgrQryBo();
        agrAgrQryBo1.setScopeType(AgrCommConstant.ScopeType.ALL);
        List<AgrAppScope> agrAppScopes = this.iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo1);
        if (!CollectionUtils.isEmpty(agrAppScopes)) {
            otherAgrAppScopes.addAll(agrAppScopes);
        }
        if (CollectionUtils.isEmpty(otherAgrAppScopes)) {
            return rspBo;
        }
        ArrayList<String> pCodeList = new ArrayList<String>();
        pCodeList.add("AGREEMENT_SRC");
        pCodeList.add("AGR_ITEM_IS_CONTROL_PCODE");
        pCodeList.add("AGR_ITEM_IS_PRICE_ADJUST_PCODE");
        pCodeList.add("AGR_ITEM_STATUS_PCODE");
        Map<String, Map<String, DicDictionaryBo>> dicMap = this.iAgrDictionaryModel.selectByPCodeListToMap(pCodeList);
        AgrAgrQryBo agrQryBo = new AgrAgrQryBo();
        agrQryBo.setAgrIds(otherAgrAppScopes.stream().map(AgrAppScope::getAgrId).distinct().collect(Collectors.toList()));
        agrQryBo.setPageNo(-1);
        agrQryBo.setPageSize(-1);
        agrQryBo.setAgrStatus(AgrCommConstant.AgreementStatus.ENABLE);
        agrQryBo.setAgrType(AgrCommConstant.AgrType.AGR);
        AgrGetAgrMainListRspQryBo agrMainList = this.iAgrAgrModel.getAgrMainList(agrQryBo);
        Map<Long, AgrAgrDo> agrMap = agrMainList.getRows().stream().collect(Collectors.toMap(AgrAgrDo::getAgrId, agrAgrDo -> agrAgrDo, (k1, k2) -> k1));
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
        agrItemListQryReqPageBo.setAgrItemIds(otherAgrAppScopes.stream().map(AgrAppScope::getAgrItemId).distinct().collect(Collectors.toList()));
        agrItemListQryReqPageBo.setMaterialCodeList(reqBo.getMaterialCodeList());
        agrItemListQryReqPageBo.setPageNo(reqBo.getPageNo());
        agrItemListQryReqPageBo.setPageSize(reqBo.getPageSize());
        AgrItemListQryRspPageBo agrItemList = this.iAgrAgrModel.qryAgrItemList(agrItemListQryReqPageBo);
        rspBo = (AgrGetAgrItemListByOrgIdRspBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)agrItemList), AgrGetAgrItemListByOrgIdRspBo.class);
        rspBo.setRows(rspBo.getRows().stream().filter(row -> agrMap.containsKey(row.getAgrId())).collect(Collectors.toList()));
        for (AgrItemBo row2 : rspBo.getRows()) {
            if (!agrMap.containsKey(row2.getAgrId())) continue;
            AgrAgrDo agrAgrDo2 = agrMap.get(row2.getAgrId());
            row2.setSupplierId(agrAgrDo2.getSupplierId());
            row2.setSupplierName(agrAgrDo2.getSupplierName());
            row2.setAgrCode(agrAgrDo2.getAgrCode());
            row2.setRelCode(agrAgrDo2.getRelCode());
            row2.setAgrSrc(agrAgrDo2.getAgrSrc());
            row2.setExecutionMethod(agrAgrDo2.getExecutionMethod());
            row2.setEffDate(agrAgrDo2.getEffDate());
            row2.setExpDate(agrAgrDo2.getExpDate());
            row2.setAgrStatus(agrAgrDo2.getAgrStatus());
        }
        this.translation(rspBo, dicMap, agrMap);
        return rspBo;
    }

    private void translation(AgrGetAgrItemListByOrgIdRspBo rspBO, Map<String, Map<String, DicDictionaryBo>> dicMap, Map<Long, AgrAgrDo> agrMap) {
        List rows;
        if (rspBO != null && !CollectionUtils.isEmpty((Collection)(rows = rspBO.getRows()))) {
            rows.forEach(x -> {
                if (agrMap.containsKey(x.getAgrId())) {
                    x.setAgrCode(((AgrAgrDo)agrMap.get(x.getAgrId())).getAgrCode());
                }
                if (x.getAgrSrc() != null) {
                    x.setAgrSrcStr(MapUtil.isEmpty((Map)((Map)dicMap.get("AGREEMENT_SRC"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("AGREEMENT_SRC")).get(x.getAgrSrc().toString())).getTitle());
                }
                if (x.getIsControlPurchaseNum() != null) {
                    x.setIsControlPurchaseNumStr(MapUtil.isEmpty((Map)((Map)dicMap.get("AGR_ITEM_IS_CONTROL_PCODE"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("AGR_ITEM_IS_CONTROL_PCODE")).get(x.getIsControlPurchaseNum().toString())).getTitle());
                }
                if (x.getIsPriceAdjust() != null) {
                    x.setIsPriceAdjustStr(MapUtil.isEmpty((Map)((Map)dicMap.get("AGR_ITEM_IS_PRICE_ADJUST_PCODE"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("AGR_ITEM_IS_PRICE_ADJUST_PCODE")).get(x.getIsPriceAdjust().toString())).getTitle());
                }
                if (x.getAgrItemStatus() != null) {
                    x.setAgrItemStatusStr(MapUtil.isEmpty((Map)((Map)dicMap.get("AGR_ITEM_STATUS_PCODE"))) ? null : ((DicDictionaryBo)((Map)dicMap.get("AGR_ITEM_STATUS_PCODE")).get(x.getAgrItemStatus().toString())).getTitle());
                }
            });
        }
    }

    private void virifyReq(AgrGetAgrItemListByOrgIdReqBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPurOrgPath())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u91c7\u8d2d\u5355\u4f4d\u673a\u6784\u6811]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getMaterialCodeList())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u96c6\u5408[\u7269\u6599\u7f16\u7801\u96c6\u5408]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void main(String[] args) {
        Date currentDate = new Date();
        String exp = "2024-07-24";
        DateTime expDate1 = DateUtil.parse((CharSequence)exp, (String)"yyyy-MM-dd");
        Date expDate = new Date();
        System.out.println(currentDate);
        System.out.println(DateUtil.formatDate((Date)expDate));
        System.out.println("=======\u5230\u671f\u65f6\u95f4\u4e0d\u5728\u5f53\u524d\u65f6\u95f4\u4e4b\u524d" + !expDate1.before((Date)DateUtil.parse((CharSequence)DateUtil.formatDate((Date)currentDate), (String)"yyyy-MM-dd")));
        if (expDate.after(currentDate)) {
            System.out.println("Expiration date is in the future.");
        } else if (!expDate.before((Date)DateUtil.parse((CharSequence)DateUtil.formatDate((Date)currentDate), (String)"yyyy-MM-dd"))) {
            System.out.println("111.");
        }
    }
}

