package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.service.agr.bo.AgrAppScopeBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMainListBo;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @title: AgrGetAgrMainListServiceImpl
 * @describe： 协议主体列表查询服务实现
 * @created: 2022/9/15 15:45
 * @author: FKC
 */
@Slf4j
@HTServiceImpl
public class AgrGetAgrMainListServiceImpl implements AgrGetAgrMainListService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;


    @Override
    public AgrGetAgrMainListRspBO getAgrMainList(AgrGetAgrMainListReqBO agrGetAgrMainListReqBO) {
        // 设置分页参数
        if (ObjectUtil.isEmpty(agrGetAgrMainListReqBO.getPageNo()) && ObjectUtil.isEmpty(agrGetAgrMainListReqBO.getPageSize())) {
            // 默认全量查询
            agrGetAgrMainListReqBO.setPageNo(-1);
            agrGetAgrMainListReqBO.setPageSize(-1);
        }
        //1 组装协议主题信息查询入参
        AgrAgrQryBo agrAgrQryBo = JSON.parseObject(JSON.toJSONString(agrGetAgrMainListReqBO), AgrAgrQryBo.class);
        //2 调用协议主体列表查询方法
        AgrGetAgrMainListRspQryBo agrGetAgrMainListRspQryBo = this.iAgrAgrModel.getAgrMainList(agrAgrQryBo);
        List<AgrAgrDo> agrAgrDos = agrGetAgrMainListRspQryBo.getRows();
        //3 出参属性类型装换
        List<AgrMainListBo> rows = JSONArray.parseArray(JSON.toJSONString(agrAgrDos)).toJavaList(AgrMainListBo.class);
        //增加协议范围的查询，商品数据库使用
            if (!CollectionUtils.isEmpty(rows) && (agrGetAgrMainListReqBO.getQueryScopeFlag() == null || agrGetAgrMainListReqBO.getQueryScopeFlag() != 0)) {
                List<Long> agrIds = rows.stream().map(AgrMainListBo::getAgrId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(agrIds)) {
                    AgrAgrQryBo qryBo = new AgrAgrQryBo();
                    qryBo.setAgrIds(agrIds);
                    List<AgrAppScope> agrAppScopes = this.iAgrAgrModel.getAgrAppScopeList(qryBo);
                    if (!CollectionUtils.isEmpty(agrAppScopes)) {
                        Map<Long, List<AgrAppScope>> agrAppScopeMap = agrAppScopes.stream().collect(Collectors.groupingBy(AgrAppScope::getAgrId));
                        rows.forEach(row -> {
                            if (agrAppScopeMap.containsKey(row.getAgrId())) {
                                row.setAppScopeBos(AgrRu.jsl(agrAppScopeMap.get(row.getAgrId()), AgrAppScopeBo.class));
                            }
                        });
                    }
                }
            }
        //4 出参设置
        AgrGetAgrMainListRspBO agrGetAgrMainListRspBO = new AgrGetAgrMainListRspBO();
        agrGetAgrMainListRspBO.setRows(rows);
        agrGetAgrMainListRspBO.setPageNo(agrGetAgrMainListRspQryBo.getPageNo());
        agrGetAgrMainListRspBO.setTotal(agrGetAgrMainListRspQryBo.getTotal());
        agrGetAgrMainListRspBO.setRecordsTotal(agrGetAgrMainListRspQryBo.getRecordsTotal());
        return agrGetAgrMainListRspBO;
    }
}
