package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryRspPageBo;
import com.tydic.dyc.agr.service.agrchange.bo.*;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者: dmc
 * 时间: 2022/9/14 14:49
 * 描述:
 */
@HTServiceImpl
@Slf4j
public class AgrGetAgrItemChngListServiceImpl implements AgrGetAgrItemChngListService{

    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @Override
    public AgrGetAgrItemChngListRspBO getAgrItemChngList(AgrGetAgrItemChngListReqBO reqBO) {
        //1 入参校验
        this.validationParam(reqBO);
        //2 调用协议明细变更列表查询方法
        AgrItemChngListQryReqPageBo qryReqPageBo = AgrRu.js(reqBO, AgrItemChngListQryReqPageBo.class);
        AgrItemChngListQryRspPageBo agrItemChngList = iAgrChngApplyModel.getAgrItemChngList(qryReqPageBo);

        //3 封装出参信息
        return setRspBoInfo(agrItemChngList);
    }

    /**
     * 封装出参信息
     * @param agrItemChngList agrItemChngList
     * @return AgrGetAgrItemChngListRspBO
     */
    private AgrGetAgrItemChngListRspBO setRspBoInfo(AgrItemChngListQryRspPageBo agrItemChngList) {
        AgrGetAgrItemChngListRspBO rspBO = AgrRu.js(agrItemChngList, AgrGetAgrItemChngListRspBO.class);
        List<AgrItemChngBo> rows = new ArrayList<>();
        if(!ObjectUtil.isEmpty(agrItemChngList.getRows())){
            rows = JSONArray.parseArray(JSON.toJSONString(agrItemChngList.getRows())).toJavaList(AgrItemChngBo.class);
        }
        //明细变更类型转义
        rows.forEach(agrItemChngBo ->{
            agrItemChngBo.setItemChngTypeStr(AgrCommConstant.AgrItemChngTypeEnum.getValueByCode(agrItemChngBo.getItemChngType()));
        });
        //是否成品油转义
        rows.forEach(agrItemChngBo ->{
            if(agrItemChngBo.getWhetherOil()!=null){
                agrItemChngBo.setWhetherOilStr(AgrCommConstant.IsOilPcodeEnum.getValueByCode(agrItemChngBo.getWhetherOil()));
            }
        });
        rspBO.setRows(rows);
        return rspBO;
    }

    /**
     * 入参检验
     * @param reqBO reqBO
     */
    private void validationParam(AgrGetAgrItemChngListReqBO reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getChngApplyId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPageNo())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[当前页]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPageSize())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[查询每页条数]不能为空");
        }
    }
}
