package com.tydic.dyc.agr.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrItemChng;
import com.tydic.dyc.agr.repository.AgrAgrChngRepository;
import com.tydic.dyc.agr.service.agr.bo.AgrItemDetailBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrGetAgrAddChngPreItemListReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrGetAgrAddChngPreItemListRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @title: AgrGetAgrAddChngPreItemListServiceImpl
 * @describe： 协议补充变更原有明细查询服务实现
 * @created: 2022/9/15 16:32
 * @author: FKC
 */
@HTServiceImpl
@Slf4j
public class AgrGetAgrAddChngPreItemListServiceImpl implements AgrGetAgrAddChngPreItemListService {
    @Autowired
    private AgrAgrChngRepository agrAgrChngRepository;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrGetAgrAddChngPreItemListRspBO getAgrAddChngPreItemList(AgrGetAgrAddChngPreItemListReqBO reqBo) {
        //1.入参校验
        this.validation(reqBo);

        //2.根据协议ID，协议变更申请ID，变更类型为删除 查询协议变更明细列表并获取协议明细ID集合
        List<Long> agrItemIds = this.getAgrItemChngList(reqBo);

        //3.根据协议ID，明细ID不在agrItemIds 查询出的协议明细
        //查询协议明细列表
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = AgrRu.js(reqBo,AgrItemListQryReqPageBo.class);
        agrItemListQryReqPageBo.setNotAgrItemIds(agrItemIds);
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
        //4.组装出参
        AgrGetAgrAddChngPreItemListRspBO rspBO = AgrRu.js(agrItemListQryRspPageBo, AgrGetAgrAddChngPreItemListRspBO.class);
        // 转义
        this.translation(rspBO);

        return rspBO;
    }
    /**
     * 是否成品油转义
     * @param rspBO 入参
     */
    private void translation(AgrGetAgrAddChngPreItemListRspBO rspBO) {
        if (rspBO != null) {
            List<AgrItemDetailBo> rows = rspBO.getRows();
            if (!CollectionUtils.isEmpty(rows)) {
                rows.forEach(x -> {
                            Integer whetherOil = x.getWhetherOil();
                            if (whetherOil != null) {
                                x.setWhetherOilStr(AgrCommConstant.IsOilPcodeEnum.getValueByCode(whetherOil));
                            }
                        }
                );
            }
        }
    }

    /**
     * 查询协议变更明细列表并获取协议明细ID集合
     *
     * @param reqBo
     * @return
     */
    private List<Long> getAgrItemChngList(AgrGetAgrAddChngPreItemListReqBO reqBo) {
        //查询协议变更明细列表
        AgrItemChngListQryReqPageBo agrItemChngListQryReqPageBo = JSON.parseObject(JSON.toJSONString(reqBo), AgrItemChngListQryReqPageBo.class);
        agrItemChngListQryReqPageBo.setItemChngType(AgrCommConstant.AgreementSkuChangeType.DELETE);
        AgrItemChngListQryRspPageBo agrItemChngListQryRspPageBo = this.agrAgrChngRepository.getAgrItemChngList(agrItemChngListQryReqPageBo);
        //获取删除类型的协议明细集合
        List<Long> agrItemIds = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(agrItemChngListQryRspPageBo)) {
            List<AgrItemChng> agrItemChngs = agrItemChngListQryRspPageBo.getRows();
            if (!CollectionUtils.isEmpty(agrItemChngs)) {
                agrItemChngs.stream().map(AgrItemChng::getAgrItemId).forEach(agrItemId -> agrItemIds.add(agrItemId));
            }
        }
        return agrItemIds;
    }

    /**
     * 入参校验
     *
     * @param reqBo
     */
    private void validation(AgrGetAgrAddChngPreItemListReqBO reqBo) {
        if (ObjectUtil.isEmpty(reqBo)) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getChngApplyId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getPageNo())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[当前页]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getPageSize())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[每页条数]不能为空");
        }
    }
}
