package com.tydic.dyc.agr.service.agr;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrItemSaveCheckReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrItemSaveCheckRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:AgrAgrItemSaveCheckServiceImpl
 * 说明:TODO
 * 时间:2023/4/23 14:10
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrAgrItemSaveCheckServiceImpl implements AgrAgrItemSaveCheckService {
    @Autowired
    private IAgrAgrModel agrAgrModel;
    @Override
    public AgrAgrItemSaveCheckRspBO checkAgrItemSave(AgrAgrItemSaveCheckReqBO agrAgrItemSaveCheckReqBO) {
        if(agrAgrItemSaveCheckReqBO.getAgrId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "协议ID不能为空");
        }
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(agrAgrItemSaveCheckReqBO.getAgrId());
        this.agrAgrModel.checkAgrItemSave(agrAgrDo);
        return AgrRu.success(AgrAgrItemSaveCheckRspBO.class);
    }
}
