package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrItemReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrItemRspBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccReqBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@HTServiceImpl
public class AgrCreateAgrItemServiceImpl implements AgrCreateAgrItemService {

    @Autowired
    private IAgrAgrModel agrAgrModel;

    @Value("${AGR_SKU_CHANGE_TOPIC}")
    private String agrSkuChangeTopic;

    @Value("${AGR_SKU_CHANGE_TAG}")
    private String agrSkuChangeTag;

    @Resource(name = "agrSyncSkuStatusMqServiceProvider")
    private ProxyMessageProducer agrSyncSkuStatusMqServiceProvider;

    @Override
    public AgrCreateAgrItemRspBo createAgrItem(AgrCreateAgrItemReqBo agrCreateAgrItemReqBo) {
        AgrCreateAgrItemRspBo rspBo = new AgrCreateAgrItemRspBo();
        //1 校验
        this.validParam(agrCreateAgrItemReqBo);
        //2 组装入参数据
        AgrAgrDo agrAgrDo = JSONObject.parseObject(JSONObject.toJSONString(agrCreateAgrItemReqBo), AgrAgrDo.class);
        // 如果协议明细ID存在，则先删除后新增
        this.deleteAgrItem(agrCreateAgrItemReqBo);
        //3 调用协议明细新增法
        this.agrAgrModel.saveAgrItem(agrAgrDo);
        //4 停启用操作对明细上的商品进行冻结、上架
        operSkuStatus(agrCreateAgrItemReqBo, agrAgrDo);
        rspBo.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        return rspBo;
    }

    /**
     * 删除明细
     */
    private void deleteAgrItem(AgrCreateAgrItemReqBo agrCreateAgrItemReqBo) {
        List<Long> agrItemIds = new ArrayList<>();
        agrCreateAgrItemReqBo.getAgrItem().forEach(agrItem -> {
            agrItemIds.add(agrItem.getAgrItemId());
        });
        if (!CollectionUtils.isEmpty(agrItemIds)) {
            AgrAgrDo agrAgrDo1 = new AgrAgrDo();
            agrAgrDo1.setAgrId(agrCreateAgrItemReqBo.getAgrId());
            List<AgrItem> agrItems = new ArrayList<>();
            AgrItem agrItem = new AgrItem();
            agrItem.setAgrId(agrCreateAgrItemReqBo.getAgrId());
            agrItem.setAgrItemIds(agrItemIds);
            agrItems.add(agrItem);
            agrAgrDo1.setAgrItem(agrItems);
            this.agrAgrModel.deleteAgrItemByBatch(agrAgrDo1);
        }
    }

    /**
     * 校验重复
     */
    private void validParam(AgrCreateAgrItemReqBo agrCreateAgrItemReqBo) {
        if (agrCreateAgrItemReqBo.getAgrId() == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_OBJ_EMPTY_ERROR, "协议ID不能为空");
        }
        if (CollectionUtils.isEmpty(agrCreateAgrItemReqBo.getAgrItem())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_OBJ_EMPTY_ERROR, "协议明细不能为空");
        }
    }


    /**
     * 恢复商品状态
     */
    private String toUpShelf(AgrSyncUccReqBO agrSyncUccReqBO) {
        Map<String, Object> content = new HashMap<>();
        List<Long> agreementIds = new ArrayList<>();
        List<Long> agreementItemIds = new ArrayList<>();
        //调用协议详情查询方法
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(agrSyncUccReqBO.getAgrId());
        AgrAgrDo agrDetail = this.agrAgrModel.getAgrDetail(agrAgrQryBo);
        //框架协议校验协议状态、明细状态、变价数据
        if (agrDetail.getAgrType().equals(AgrCommConstant.AgrType.AGR)) {
            List<AgrItem> agrItems = agrAgrModel.checkAgrItemUnfreeze(agrSyncUccReqBO);
            if (CollectionUtil.isNotEmpty(agrItems)) {
                agreementIds = agrItems.stream().map(AgrItem::getAgrId).distinct().collect(Collectors.toList());
                agreementItemIds = agrItems.stream().map(AgrItem::getAgrItemId).distinct().collect(Collectors.toList());
            } else {
                return null;
            }
        } else {
            if (CollectionUtil.isNotEmpty(agrSyncUccReqBO.getAgrItemIds())) {
                agreementItemIds.addAll(agrSyncUccReqBO.getAgrItemIds());
            }
            agreementIds.add(agrSyncUccReqBO.getAgrId());
        }
        content.put("changeType", AgrCommConstant.AgrChangeOperType.THAW);
        content.put("agreementIds", agreementIds.stream().distinct().collect(Collectors.toList()));
        content.put("agreementSkuIds", agreementItemIds.stream().distinct().collect(Collectors.toList()));
        content.put("operId", agrSyncUccReqBO.getOperId());
        content.put("operName", agrSyncUccReqBO.getOperName());
        return JSON.toJSONString(content);
    }


    /**
     * 修改商品状态为协议冻结
     */
    private String toFrozen(AgrSyncUccReqBO agrSyncUccReqBO) {
        Map<String, Object> content = new HashMap<>();
        List<Long> agreementIds = new ArrayList<>();
        List<Long> agreementItemIds = new ArrayList<>();
        agreementIds.add(agrSyncUccReqBO.getAgrId());
        if (CollectionUtil.isNotEmpty(agrSyncUccReqBO.getAgrIds())) {
            agreementIds.addAll(agrSyncUccReqBO.getAgrIds());
        }
        if (CollectionUtil.isNotEmpty(agrSyncUccReqBO.getAgrItemIds())) {
            agreementItemIds.addAll(agrSyncUccReqBO.getAgrItemIds());
        }
        content.put("changeType", AgrCommConstant.AgrChangeOperType.FREZE);
        content.put("agreementIds", agreementIds.stream().distinct().collect(Collectors.toList()));
        content.put("agreementSkuIds", agreementItemIds.stream().distinct().collect(Collectors.toList()));
        content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_FREEZEN);
        content.put("operId", agrSyncUccReqBO.getOperId());
        content.put("operName", agrSyncUccReqBO.getOperName());
        return JSON.toJSONString(content);
    }

    /**
     * 操作商品状态
     *
     * @param agrCreateAgrItemReqBo
     * @param agrAgrDo
     */
    private void operSkuStatus(AgrCreateAgrItemReqBo agrCreateAgrItemReqBo, AgrAgrDo agrAgrDo) {
        AgrSyncUccReqBO toUpShelfAgrSyncUccReqBO = new AgrSyncUccReqBO();
        AgrSyncUccReqBO toFrozenAgrSyncUccReqBO = new AgrSyncUccReqBO();
        toUpShelfAgrSyncUccReqBO.setAgrId(agrAgrDo.getAgrId());
        toUpShelfAgrSyncUccReqBO.setOperId(null == agrCreateAgrItemReqBo.getUserId() ? "" : agrCreateAgrItemReqBo.getUserId().toString());
        toUpShelfAgrSyncUccReqBO.setOperName(agrCreateAgrItemReqBo.getUserName());
        toFrozenAgrSyncUccReqBO.setAgrId(agrAgrDo.getAgrId());
        toFrozenAgrSyncUccReqBO.setOperId(null == agrCreateAgrItemReqBo.getUserId() ? "" : agrCreateAgrItemReqBo.getUserId().toString());
        toFrozenAgrSyncUccReqBO.setOperName(agrCreateAgrItemReqBo.getUserName());
        List<Long> toUpShelfAgrItemIdList = new ArrayList<>();
        List<Long> toFrozenAgrItemIdList = new ArrayList<>();
        for (AgrItem agrItem : agrAgrDo.getAgrItem()) {
            //协议明细id不为空表示是修改操作，才对商品进行冻结、上架
            if (null != agrItem.getAgrItemId()) {
                if (0 == agrItem.getAgrItemStatus()) {
                    toFrozenAgrItemIdList.add(agrItem.getAgrItemId());
                } else if (1 == agrItem.getAgrItemStatus()) {
                    toUpShelfAgrItemIdList.add(agrItem.getAgrItemId());
                }
            }
        }
        String messageContent = "";
        // 上架
        if (!CollectionUtils.isEmpty(toUpShelfAgrItemIdList)) {
            toUpShelfAgrSyncUccReqBO.setAgrItemIds(toUpShelfAgrItemIdList);
            messageContent = this.toUpShelf(toUpShelfAgrSyncUccReqBO);
        }
        // 冻结
        if (!CollectionUtils.isEmpty(toFrozenAgrItemIdList)) {
            toFrozenAgrSyncUccReqBO.setAgrItemIds(toFrozenAgrItemIdList);
            messageContent = this.toFrozen(toFrozenAgrSyncUccReqBO);
        }
        // 发消息
        this.sendMsg(messageContent);
    }

    /**
     * 发送消息
     */
    private void sendMsg(String content) {
        if (StringUtils.hasText(content)) {
            log.info("发消息同步商品商品中心入参为" + content);
            agrSyncSkuStatusMqServiceProvider.send(new ProxyMessage(agrSkuChangeTopic, agrSkuChangeTag, content));
            log.info("发消息同步商品商品中心成功");
        }

    }
}
