package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.sub.AgrAgrVersion;
import com.tydic.dyc.agr.service.agr.bo.AgrDeleteAgrVersionRecordReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrDeleteAgrVersionRecordRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:AgrDeleteAgrVersionRecordServiceImpl
 * 说明:TODO
 * 时间:2023/7/27 15:47
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrDeleteAgrVersionRecordServiceImpl implements AgrDeleteAgrVersionRecordService{
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Override
    public AgrDeleteAgrVersionRecordRspBO deleteAgrVersionRecord(AgrDeleteAgrVersionRecordReqBO agrDeleteAgrVersionRecordReqBO) {
        //1 参数校验
        this.validationParam(agrDeleteAgrVersionRecordReqBO);
        //2 调用协议版本记录删除方法
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        List<AgrAgrVersion> agrAgrVersion = new ArrayList<>();
        AgrAgrVersion agrAgrVersion1 = AgrRu.js(agrDeleteAgrVersionRecordReqBO, AgrAgrVersion.class);
        agrAgrVersion.add(agrAgrVersion1);
        agrAgrDo.setAgrAgrVersion(agrAgrVersion);
        this.iAgrAgrModel.deleteAgrVersionRecord(agrAgrDo);
        return AgrRu.success(AgrDeleteAgrVersionRecordRspBO.class);
    }
    /**
     * 入参校验
     * @param reqBo reqBo
     */
    private void validationParam(AgrDeleteAgrVersionRecordReqBO reqBo){
        if (reqBo == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象[]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象[协议ID]不能为空");
        }
    }
}
