package com.tydic.dyc.agr.service.agr;

import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.service.agr.bo.AgrAlertInfoBO;
import com.tydic.dyc.agr.service.agr.bo.AgrDealAgrAlertInfoRspBo;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：AgrUpdateAgrAlertIsSendImpl
 * 说明：
 * 时间： 2024-08-12 17:19
 * 作者 @author LY
 */
@HTServiceImpl
public class AgrUpdateAgrAlertImpl implements AgrUpdateAgrAlert {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrDealAgrAlertInfoRspBo updateAgrAlert(AgrAlertInfoBO reqBo) {
        iAgrAgrModel.updateAgrAlertIsSend(reqBo.getSetDate(), reqBo.getWhereDate());
        AgrDealAgrAlertInfoRspBo rspBo = new AgrDealAgrAlertInfoRspBo();
        rspBo.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(AgrRspConstant.RESP_DESC_SUCCESS);
        return rspBo;
    }
}
