package com.tydic.dyc.agr.service.sysdictionary;

import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.SysDicDictionaryDo;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.SysDicDictionaryRspBo;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.sysdictionary.AgrQueryBypCodeBackPoService;
import com.tydic.dyc.agr.service.sysdictionary.bo.AgrDicDictionaryBO;
import com.tydic.dyc.agr.service.sysdictionary.bo.AgrQueryBypCodeBackPoReqBo;
import com.tydic.dyc.agr.service.sysdictionary.bo.AgrQueryBypCodeBackPoRspBo;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * @author zengxun
 * @Description 根据Pcode查询字典集合
 * @copyright 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 * @since 2022/6/20 17:32
 */
@HTServiceImpl
@Slf4j
public class AgrQueryBypCodeBackPoServiceImpl implements AgrQueryBypCodeBackPoService {
    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;
    @Override
    public AgrQueryBypCodeBackPoRspBo queryBypCodeBackPo(AgrQueryBypCodeBackPoReqBo reqBo) {
        AgrQueryBypCodeBackPoRspBo rspBo = new AgrQueryBypCodeBackPoRspBo();
        rspBo.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        rspBo.setRespDesc("成功");
        if (StringUtils.isEmpty(reqBo.getPCode())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR,"入参Pcode不能为空");
        }
        SysDicDictionaryRspBo sysDicDictionaryRspBo = this.iAgrDictionaryModel.queryBypCodeBackPo(AgrRu.js(reqBo, SysDicDictionaryDo.class));
        List<SysDicDictionaryDo> sysDicDictionaryDos = sysDicDictionaryRspBo.getRows();
        if (CollectionUtils.isEmpty(sysDicDictionaryDos)) {
            rspBo.setRespDesc("查询结果为空");
            return rspBo;
        }
        rspBo.setData(AgrRu.jsl(sysDicDictionaryDos, AgrDicDictionaryBO.class));
        return rspBo;
    }
}
