package com.tydic.dyc.agr.service.sysdictionary;

import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.SysDicDictionaryDo;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.sysdictionary.AgrUpdateDictionaryService;
import com.tydic.dyc.agr.service.sysdictionary.bo.AgrUpdateByPCodeReqBo;
import com.tydic.dyc.agr.service.sysdictionary.bo.AgrUpdateByPCodeRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：AgrUpdateDictionaryServiceImpl
 * 说明：
 * 时间：2022/7/6 15:56
 * 作者：huzhongbao
 */
@HTServiceImpl
@Slf4j
public class AgrUpdateDictionaryServiceImpl implements AgrUpdateDictionaryService {
    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;

    @Override
    public AgrUpdateByPCodeRspBo updateDicDictionary(AgrUpdateByPCodeReqBo AgrUpdateByPCodeReqBo) {
        SysDicDictionaryDo sysDicDictionaryDo = new SysDicDictionaryDo();
        BeanUtils.copyProperties(AgrUpdateByPCodeReqBo, sysDicDictionaryDo);
        iAgrDictionaryModel.updateDicDictionary(sysDicDictionaryDo);
        AgrUpdateByPCodeRspBo rspBo = new AgrUpdateByPCodeRspBo();
        rspBo.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        rspBo.setRespDesc("成功");
        return rspBo;
    }
}
