/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agrchange;

import com.tydic.dyc.agr.service.agrchange.AgrGetAgrChngCodeService;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngCodeReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngCodeRspBO;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agrchange.AgrGetAgrChngCodeService"})
public class AgrGetAgrChngCodeServiceImpl
implements AgrGetAgrChngCodeService {
    private static final Logger log = LoggerFactory.getLogger(AgrGetAgrChngCodeServiceImpl.class);
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @PostMapping(value={"getAgrChngCode"})
    public AgrGetAgrChngCodeRspBO getAgrChngCode(@RequestBody AgrGetAgrChngCodeReqBO agrGetAgrChngCodeReqBO) {
        this.validation(agrGetAgrChngCodeReqBO);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = this.packageEncodeParams(agrGetAgrChngCodeReqBO);
        log.debug("\u83b7\u53d6\u534f\u8bae\u53d8\u66f4\u7f16\u7801\u5165\u53c2=" + encodedSerialGetServiceReqBO);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        log.debug("\u83b7\u53d6\u534f\u8bae\u53d8\u66f4\u7f16\u7801\u51fa\u53c2=" + encodedSerialGetServiceRspBO);
        return this.packageGinseng(encodedSerialGetServiceRspBO);
    }

    private AgrGetAgrChngCodeRspBO packageGinseng(CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO) {
        List serialNoList;
        String chngApplyNo = "";
        AgrGetAgrChngCodeRspBO agrGetAgrChngCodeRspBO = new AgrGetAgrChngCodeRspBO();
        if (encodedSerialGetServiceRspBO != null && !CollectionUtils.isEmpty((Collection)(serialNoList = encodedSerialGetServiceRspBO.getSerialNoList()))) {
            chngApplyNo = (String)serialNoList.get(0);
            agrGetAgrChngCodeRspBO.setChngApplyNo(chngApplyNo);
        }
        agrGetAgrChngCodeRspBO.setRespCode("0000");
        agrGetAgrChngCodeRspBO.setChngApplyId(Long.valueOf(IdUtil.nextId()));
        return agrGetAgrChngCodeRspBO;
    }

    private CfcEncodedSerialGetServiceReqBO packageEncodeParams(AgrGetAgrChngCodeReqBO agrGetAgrChngCodeReqBO) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        if (null != agrGetAgrChngCodeReqBO.getChangeType()) {
            switch (agrGetAgrChngCodeReqBO.getChangeType()) {
                case 1: {
                    encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_UPDATE_CODE_ZT");
                    break;
                }
                case 2: {
                    encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_UPDATE_CODE_QY");
                    break;
                }
                case 3: {
                    encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_UPDATE_CODE_ZZ");
                    break;
                }
                case 4: {
                    encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_UPDATE_CODE_TJ");
                    break;
                }
                case 5: {
                    encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_UPDATE_CODE_YQ");
                    break;
                }
                case 6: {
                    encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_UPDATE_CODE_BG");
                    break;
                }
                case 7: {
                    encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_UPDATE_CODE_QT");
                    break;
                }
            }
        }
        ArrayList<String> replaceValueList = new ArrayList<String>();
        replaceValueList.add(agrGetAgrChngCodeReqBO.getPlaAgreementCode());
        encodedSerialGetServiceReqBO.setCenter("AGR");
        encodedSerialGetServiceReqBO.setReplaceValue(replaceValueList);
        return encodedSerialGetServiceReqBO;
    }

    private void validation(AgrGetAgrChngCodeReqBO agrGetAgrChngCodeReqBO) {
        if (agrGetAgrChngCodeReqBO == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2[agrGetAgrChngCodeReqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (agrGetAgrChngCodeReqBO.getChangeType() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2[changeType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (agrGetAgrChngCodeReqBO.getPlaAgreementCode() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2[plaAgreementCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

