/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.domainservice;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrAgrStatusChngAuditCallBackService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrStatusChngAuditCallBackReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrStatusChngAuditCallBackRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.domainservice.AgrAgrStatusChngAuditCallBackService"})
public class AgrAgrStatusChngAuditCallBackServiceImpl
implements AgrAgrStatusChngAuditCallBackService {
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"dealStatusChngAuditCallBack"})
    public AgrAgrStatusChngAuditCallBackRspBO dealStatusChngAuditCallBack(@RequestBody AgrAgrStatusChngAuditCallBackReqBO reqBO) {
        this.invokeAgrChngApplyMain(reqBO);
        this.invokeUpdateAgrMain(reqBO);
        return AgrRu.success(AgrAgrStatusChngAuditCallBackRspBO.class);
    }

    private void invokeUpdateAgrMain(AgrAgrStatusChngAuditCallBackReqBO reqBO) {
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(reqBO.getAgrId());
        if (reqBO.getChngType().equals(AgrCommConstant.AgreementChangeType.START)) {
            agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.ENABLE);
        }
        if (reqBO.getChngType().equals(AgrCommConstant.AgreementChangeType.STOP)) {
            agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.SUSPEND);
        }
        if (reqBO.getChngType().equals(AgrCommConstant.AgreementChangeType.TERMINATION)) {
            agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.TERMINATION);
        }
        this.iAgrAgrModel.updateAgrMain(agrAgrDo);
    }

    private void invokeAgrChngApplyMain(AgrAgrStatusChngAuditCallBackReqBO reqBO) {
        AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
        agrChngApplyDo.setAgrId(reqBO.getAgrId());
        agrChngApplyDo.setChngApplyId(reqBO.getChngApplyId());
        agrChngApplyDo.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.PASS);
        this.iAgrChngApplyModel.updateAgrChngApplyMain(agrChngApplyDo);
    }
}

