package com.tydic.dyc.agr.model.agr.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.*;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.repository.AgrAgrRepository;
import com.tydic.dyc.agr.service.agr.bo.AgrAlertInfoBO;
import com.tydic.dyc.agr.service.agr.bo.AgrItemPriceExecutionBo;
import com.tydic.dyc.agr.service.agr.bo.AgrQueryAlertStatisticsReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrQueryAlertStatisticsRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccReqBO;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 标题:IAgrAgrModelImpl
 * 说明:协议Model
 * 时间:2022/8/23 15:26
 * 作者:代愿愿
 */
@Service
public class IAgrAgrModelImpl implements IAgrAgrModel {

    @Autowired
    private AgrAgrRepository agrAgrRepository;

    @Override
    public void updateAgrMain(AgrAgrDo agrAgrDo) {
        //参数验证
        this.validation(agrAgrDo);
        //协议主体修改
        agrAgrRepository.updateAgrMain(agrAgrDo);
    }

    @Override
    public AgrListQryRspPageBo getAllAgrList(AgrListQryReqPageBo agrListQryReqPageBo) {
        return agrAgrRepository.getAllAgrList(agrListQryReqPageBo);
    }

    /**
     * 协议主体修改方法参数验证
     *
     * @param agrAgrDo
     */
    private void validation(AgrAgrDo agrAgrDo) {
        if (agrAgrDo == null || agrAgrDo.getAgrId() == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
    }

    @Override
    public void createAgr(AgrAgrDo agrAgrDo) {
        if (agrAgrDo.getAgrId() == null) {
            agrAgrDo.setAgrId(IdUtil.nextId());
        }
        if (ObjectUtil.isEmpty(agrAgrDo.getAgrVersion())) {
            agrAgrDo.setAgrVersion("V1");
        }
        if (ObjectUtil.isEmpty(agrAgrDo.getAgrStatus())) {
            agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.DRAFT);
        }
//        if (ObjectUtil.isEmpty(agrAgrDo.getOperTime())) {
//            // 创建一个Calendar实例并设置为当前时间
//            Calendar calendar = Calendar.getInstance();
//            // 将时间部分设置为0
//            calendar.set(Calendar.HOUR_OF_DAY, 0);
//            calendar.set(Calendar.MINUTE, 0);
//            calendar.set(Calendar.SECOND, 0);
//            calendar.set(Calendar.MILLISECOND, 0);
//            // 获取修改后的时间作为Date对象
//            Date dateWithZeroTime = calendar.getTime();
//            agrAgrDo.setOperTime(dateWithZeroTime);
//        } else {
//            // 转换为ZonedDateTime
//            ZonedDateTime zonedDateTime = agrAgrDo.getOperTime().toInstant().atZone(ZoneId.systemDefault());
//            // 提取LocalDate，自动去除时分秒
//            LocalDate localDate = zonedDateTime.toLocalDate();
//            // 再次转换回Date
//            Date dateAtMidnight = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
//            agrAgrDo.setOperTime(dateAtMidnight);
//        }
        //协议主体新增
        agrAgrRepository.saveAgrMain(agrAgrDo);
        //协议子实体新增
        agrAgrRepository.saveAgrSub(agrAgrDo);
    }

    @Override
    public void updateAgr(AgrAgrDo agrAgrDo) {
        //入参校验
        this.validateAgrMain(agrAgrDo);
        //修改协议主体
        this.agrAgrRepository.updateAgrMain(agrAgrDo);
        //删除协议子实体
        this.agrAgrRepository.deleteAgrSub(agrAgrDo);
        //新增协议子实体
        this.agrAgrRepository.saveAgrSub(agrAgrDo);
    }

    @Override
    public AgrAgrDo getAgrMain(AgrAgrQryBo agrAgrQryBo) {
        //协议主体查询
        return this.agrAgrRepository.getAgrMain(agrAgrQryBo);
    }

    @Override
    public void deleteAgr(AgrAgrDo agrAgrDo) {
        if (agrAgrDo.getAgrId() == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        //协议主体删除
        this.agrAgrRepository.deleteAgrMain(agrAgrDo);
    }

    @Override
    public AgrAgrDo getAgrDetail(AgrAgrQryBo agrAgrQryBo) {
        //协议详情查询
        return this.agrAgrRepository.getAgrDetail(agrAgrQryBo);
    }

    @Override
    public AgrItemListQryRspPageBo getAgrItemList(AgrItemListQryReqPageBo agrItemListQryReqPageBo) {
        //协议明细列表查询
        return this.agrAgrRepository.getAgrItemtList(agrItemListQryReqPageBo);
    }

    @Override
    public void saveAgrItem(AgrAgrDo agrAgrDo) {
        if (agrAgrDo.getAgrId() == null) {
            if (ObjectUtil.isEmpty(agrAgrDo.getAgrId())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
            }
        }
        //新增协议明细
        this.agrAgrRepository.saveAgrItem(agrAgrDo);

    }

    @Override
    public void updateAgrItem(AgrAgrDo agrAgrDo) {
        if (agrAgrDo.getAgrId() == null || CollectionUtils.isEmpty(agrAgrDo.getAgrItem())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        //批量删除协议明细
        this.agrAgrRepository.deleteAgrItemByBatch(agrAgrDo);
        //新增协议明细
        this.agrAgrRepository.saveAgrItem(agrAgrDo);
    }

    @Override
    public void deleteAgrItemByBatch(AgrAgrDo agrAgrDo) {
        if (agrAgrDo.getAgrId() == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        //批量删除协议明细
        this.agrAgrRepository.deleteAgrItemByBatch(agrAgrDo);

    }

    @Override
    public void updateAgrItemByBatch(AgrAgrDo agrAgrDo) {
//        if (agrAgrDo.getAgrId() == null || CollectionUtils.isEmpty(agrAgrDo.getAgrItem())) {
//            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
//        }
        this.agrAgrRepository.updateAgrItemByBatch(agrAgrDo);

    }

    @Override
    public void saveAgrAllocateRecord(AgrAgrDo agrAgrDo) {
        //入参检验
        this.validateAllocatrRecord(agrAgrDo);
        //新增协议分配记录
        this.agrAgrRepository.saveAgrAllocateRecord(agrAgrDo);
    }

    @Override
    public AgrAgrAllocateRecordListRspBO getAgrAllocateRecordList(AgrAgrQryBo agrAgrQryBo) {
        //协议分配记录列表查询
        return this.agrAgrRepository.getAgrAllocateRecordList(agrAgrQryBo);
    }

    @Override
    public AgrGetAgrMainListRspQryBo getAgrMainList(AgrAgrQryBo agrAgrQryBo) {
        //协议主体列表查询
        return this.agrAgrRepository.getAgrMainList(agrAgrQryBo);
    }

    @Override
    public AgrGetAgrItemCountByCommodityTypeRspPageBo getAgrItemCount(AgrGetAgrItemCountByCommodityTypeReqPageBo reqPageBo) {
        return this.agrAgrRepository.getAgrItemCountByCommodityType(reqPageBo);
    }

    @Override
    public void saveAgrVersion(AgrAgrDo agrAgrDo) {
        this.agrAgrRepository.saveAgrVersion(agrAgrDo);
    }

    @Override
    public void disValidAgrVersion(AgrAgrDo agrAgrDo) {
        this.agrAgrRepository.disValidAgrVersion(agrAgrDo);
    }

    @Override
    public AgrGetAgrVersionListRspBo getAgrVersionList(AgrGetAgrVersionListReqBo agrGetAgrVersionListReqBo) {
        return this.agrAgrRepository.getAgrVersionList(agrGetAgrVersionListReqBo);
    }

    @Override
    public void saveAgrHis(AgrAgrDo agrAgrDo) {
        this.agrAgrRepository.saveAgrHis(agrAgrDo);
    }

    @Override
    public void checkAgrItemSave(AgrAgrDo agrAgrDo) {
        this.agrAgrRepository.checkAgrItemSave(agrAgrDo);
    }

    @Override
    public void updateAgrItemSpecifyField(AgrAgrDo agrAgrDo) {
        this.agrAgrRepository.updateAgrItemSpecifyField(agrAgrDo);
    }

    @Override
    public void deleteAgrVersionRecord(AgrAgrDo agrAgrDo) {
        this.agrAgrRepository.deleteAgrVersionRecord(agrAgrDo);
    }

    @Override
    public AgrGetAgrMainListRspQryBo dealAgrInvalid(AgrAgrDo agrAgrDo) {
        return this.agrAgrRepository.dealAgrInvalid(agrAgrDo);
    }

    @Override
    public void dealChangeSyn(AgrAgrDo agrAgrDo) {
        this.agrAgrRepository.dealChangeSyn(agrAgrDo);
    }

    @Override
    public List<AgrAppScope> getAgrAppScopeList(AgrAgrQryBo agrAgrQryBo) {
        return this.agrAgrRepository.getAgrAppScopeList(agrAgrQryBo);
    }

    @Override
    public void updateAgrChngMain(AgrAgrDo agrAgrDo) {
        //入参校验
        this.validateAgrMain(agrAgrDo);
        //修改协议主体
        this.agrAgrRepository.updateAgrChngMain(agrAgrDo);
        //删除协议子实体
        this.agrAgrRepository.deleteAgrSub(agrAgrDo);
        //新增协议子实体
        this.agrAgrRepository.saveAgrSub(agrAgrDo);
    }

    /**
     * 协议明细列表查询
     *
     * @param agrItemListQryReqPageBo
     */
    @Override
    public AgrItemListQryRspPageBo qryAgrItemList(AgrItemListQryReqPageBo agrItemListQryReqPageBo) {

        //协议明细列表查询
        return this.agrAgrRepository.qryAgrItemtList(agrItemListQryReqPageBo);
    }

    /**
     * 新增协议明细价格执行
     *
     * @param agrItemPriceExecutionBoList
     */
    @Override
    public void createAgrItemPriceExecution(List<AgrItemPriceExecutionBo> agrItemPriceExecutionBoList) {
        this.agrAgrRepository.createAgrItemPriceExecution(agrItemPriceExecutionBoList);
    }

    /**
     * 修改协议明细价格执行
     *
     * @param agrItemPriceExecutionBoList
     */
    @Override
    public void updateAgrItemPriceExecution(List<AgrItemPriceExecutionBo> agrItemPriceExecutionBoList) {
        this.agrAgrRepository.updateAgrItemPriceExecution(agrItemPriceExecutionBoList);
    }

    /**
     * 协议明细价格执行列表查询
     *
     * @param priceExecutionQryReqPageBo
     */
    @Override
    public AgrItemListPriceExecutionQryRspPageBo getAgrItemPriceExecutionList(AgrItemListPriceExecutionQryReqPageBo priceExecutionQryReqPageBo) {
        return this.agrAgrRepository.getAgrItemPriceExecutionList(priceExecutionQryReqPageBo);
    }

    /**
     * 新增协议主体扩展
     *
     * @param agrAgrDo
     */
    @Override
    public void createAgrMainExt(AgrAgrDo agrAgrDo) {
        this.agrAgrRepository.createAgrMainExt(agrAgrDo);
    }

    /**
     * 删除协议主体扩展
     *
     * @param agrAgrDo
     */
    @Override
    public void deleteAgrMainExt(AgrAgrDo agrAgrDo) {
        this.agrAgrRepository.deleteAgrMainExt(agrAgrDo);
    }

    /**
     * 批量新增协议附件
     *
     * @param agrAgrDo
     */
    @Override
    public void insertBatchAgrAccessory(AgrAgrDo agrAgrDo) {
        this.agrAgrRepository.insertBatchAgrAccessory(agrAgrDo);
    }

    /**
     * 返回协议及协议明细允许商品解冻的协议信息
     *
     * @param agrSyncUccReqBO
     */
    @Override
    public List<AgrItem> checkAgrItemUnfreeze(AgrSyncUccReqBO agrSyncUccReqBO) {
        return agrAgrRepository.checkAgrItemUnfreeze(agrSyncUccReqBO);
    }

    /**
     * 新增协议预警信息
     *
     * @param agrAlertInfoBOList
     */
    @Override
    public void createAgrAlertInfo(List<AgrAlertInfoBO> agrAlertInfoBOList) {
        this.agrAgrRepository.createAgrAlertInfo(agrAlertInfoBOList);
    }

    /**
     * 查新协议预警集合
     *
     * @param qryAgrBo
     */
    @Override
    public List<AgrAlertInfoBO> qryAgrAlertInfoList(AgrAlertInfoBO qryAgrBo) {
        return agrAgrRepository.qryAgrAlertInfoList(qryAgrBo);
    }

    /**
     * 修改协议预警信息
     *
     * @param agrAlertInfoBOList
     */
    @Override
    public void updateAgrAlertInfo(List<AgrAlertInfoBO> agrAlertInfoBOList) {
        this.agrAgrRepository.updateAgrAlertInfo(agrAlertInfoBOList);
    }

    @Override
    public void updateAgrAlertStatus(List<AgrAlertInfoBO> agrAlertInfoBOList) {
        this.agrAgrRepository.updateAgrAlertStatus(agrAlertInfoBOList);
    }

    @Override
    public void updateAgrAlertIsSend(AgrAlertInfoBO reqSetBo, AgrAlertInfoBO reqWhereBo) {
        this.agrAgrRepository.updateAgrAlertIsSend(reqSetBo, reqWhereBo);
    }

    /**
     * 协议修改方法参数校验
     *
     * @param agrAgrDo
     */
    private void validateAgrMain(AgrAgrDo agrAgrDo) {
        if (ObjectUtil.isEmpty(agrAgrDo)) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(agrAgrDo.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
    }

    @Override
    public AgrAgrDo getAgrExtList(AgrAgrQryBo agrAgrQryBo) {
        return agrAgrRepository.getAgrExtList(agrAgrQryBo);
    }

    @Override
    public AgrQueryAlertStatisticsRspBO queryAlertStatistics(AgrQueryAlertStatisticsReqBO reqBO) {
        return agrAgrRepository.queryAlertStatistics(reqBO);
    }

    /**
     * 分配记录參數校驗
     *
     * @param agrAgrDo
     */
    private void validateAllocatrRecord(AgrAgrDo agrAgrDo) {
        if (ObjectUtil.isEmpty(agrAgrDo.getAgrAllocateRecord())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        agrAgrDo.getAgrAllocateRecord().forEach(agrAllocateRecord -> {
            if (ObjectUtil.isEmpty(agrAllocateRecord.getAgrOperatorIdOld())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[原协议经办人ID]不能为空");
            }
            if (ObjectUtil.isEmpty(agrAllocateRecord.getAgrOperatorNameOld())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[原协议经办人名称]不能为空");
            }
            if (ObjectUtil.isEmpty(agrAllocateRecord.getAgrOperatorUsernameOld())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[原协议经办人用户名]不能为空");
            }
            if (ObjectUtil.isEmpty(agrAllocateRecord.getAgrOperatorId())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议经办人ID]不能为空");
            }
            if (ObjectUtil.isEmpty(agrAllocateRecord.getAgrOperatorName())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议经办人名称]不能为空");
            }
            if (ObjectUtil.isEmpty(agrAllocateRecord.getAgrOperatorUsername())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议经办人用户名]不能为空");
            }
        });
    }


}

