package com.tydic.dyc.agr.model.sysDicDictionary;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zengxun
 * @Description 字典Do
 * @copyright 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 * @since 2022/5/18 18:10
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class SysDicDictionaryDo implements Serializable {
    private static final long serialVersionUID = 1082820361101482880L;

    public SysDicDictionaryDo(){
    }
    public SysDicDictionaryDo(String sysCode, String pCode){
        this.pCode = pCode;
        this.sysCode = sysCode;
    }

    private String code;

    private String pCode;

    @DocField(value = "系统编码")
    private String sysCode;

    private String title;

    @DocField(value = "同级排序")
    private Integer orderId;

    private String descrip;

    @DocField(value = "创建人")
    private Long createUid;

    @DocField(value = "创建时间")
    private Date createTm;

    @DocField(value = "修改人")
    private Long updateUid;

    @DocField(value = "修改时间")
    private Date updateTm;

    @DocField(value = "删除标记;0生效  1已删除")
    private Integer delFlag;

    @DocField(value = "排序")
    private String orderBy;
}
