package com.tydic.dyc.agr.repository;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.qrybo.*;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.bo.AgrAlertInfoBO;
import com.tydic.dyc.agr.service.agr.bo.AgrItemPriceExecutionBo;
import com.tydic.dyc.agr.service.agr.bo.AgrQueryAlertStatisticsReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrQueryAlertStatisticsRspBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccReqBO;

import java.util.List;

/**
 * 描述：
 *
 * @author auto_gen
 * @date 2023-08-04 17:46
 **/
public interface AgrAgrRepository {
    /**
     * 协议子实体新增
     */
    void saveAgrSub(AgrAgrDo agrAgrDo);

    /**
     * 协议主体修改
     */
    void updateAgrMain(AgrAgrDo agrAgrDo);

    /**
     * 协议主体查询
     */
    AgrAgrDo getAgrMain(AgrAgrQryBo agrAgrQryBo);

    /**
     * 协议子实体删除
     */
    void deleteAgrSub(AgrAgrDo agrAgrDo);

    /**
     * 协议详情查询
     */
    AgrAgrDo getAgrDetail(AgrAgrQryBo agrAgrQryBo);

    /**
     * 协议明细新增
     */
    void saveAgrItem(AgrAgrDo agrAgrDo);

    /**
     * 协议明细批量删除
     */
    void deleteAgrItemByBatch(AgrAgrDo agrAgrDo);

    /**
     * 协议明细批量修改
     */
    void updateAgrItemByBatch(AgrAgrDo agrAgrDo);

    /**
     * 协议明细列表查询
     */
    AgrItemListQryRspPageBo getAgrItemtList(AgrItemListQryReqPageBo agrItemListQryReqPageBo);

    /**
     * 协议主体新增
     */
    void saveAgrMain(AgrAgrDo agrAgrDo);

    /**
     * 协议主体删除
     */
    void deleteAgrMain(AgrAgrDo agrAgrDo);

    AgrListQryRspPageBo getAllAgrList(AgrListQryReqPageBo agrListQryReqPageBo);

    /**
     * 协议分配记录新增
     */
    void saveAgrAllocateRecord(AgrAgrDo agrAgrDo);

    /**
     * 协议分配记录列表查询
     */
    AgrAgrAllocateRecordListRspBO getAgrAllocateRecordList(AgrAgrQryBo agrAgrQryBo);

    /**
     * 协议主体列表查询
     */
    AgrGetAgrMainListRspQryBo getAgrMainList(AgrAgrQryBo agrAgrQryBo);

    /**
     * 根据商品类型统计协议明细数量
     */
    AgrGetAgrItemCountByCommodityTypeRspPageBo getAgrItemCountByCommodityType(AgrGetAgrItemCountByCommodityTypeReqPageBo agrGetAgrItemCountByCommodityTypeReqPageBo);

    /**
     * 协议版本记录新增
     */
    void saveAgrVersion(AgrAgrDo agrAgrDo);

    void disValidAgrVersion(AgrAgrDo agrAgrDo);

    /**
     * 协议版本记录列表查询
     */
    AgrGetAgrVersionListRspBo getAgrVersionList(AgrGetAgrVersionListReqBo agrGetAgrVersionListReqBo);

    /**
     * 协议日志新增
     */
    void saveAgrHis(AgrAgrDo agrAgrDo);

    /**
     * AGRR0041-协议保存明细校验
     */
    void checkAgrItemSave(AgrAgrDo agrAgrDo);

    /**
     * AGRR0042-协议明细批量修改指定字段
     */
    void updateAgrItemSpecifyField(AgrAgrDo agrAgrDo);

    /**
     * AGRR0050-协议版本记录删除
     */
    void deleteAgrVersionRecord(AgrAgrDo agrAgrDo);

    /**
     * AGRF0070-协议失效
     */
    AgrGetAgrMainListRspQryBo dealAgrInvalid(AgrAgrDo agrAgrDo);

    /**
     * AGRF0071-协议变更同步方法
     */
    void dealChangeSyn(AgrAgrDo agrAgrDo);

    List<AgrAppScope> getAgrAppScopeList(AgrAgrQryBo agrAgrQryBo);

    /**
     * 协议主体修改
     */
    void updateAgrChngMain(AgrAgrDo agrAgrDo);

    /**
     * 协议明细列表查询
     */
    AgrItemListQryRspPageBo qryAgrItemtList(AgrItemListQryReqPageBo agrItemListQryReqPageBo);

    /**
     * 新增协议明细价格执行
     */
    void createAgrItemPriceExecution(List<AgrItemPriceExecutionBo> agrItemPriceExecutionBoList);

    /**
     * 新增协议明细价格执行
     */
    void updateAgrItemPriceExecution(List<AgrItemPriceExecutionBo> agrItemPriceExecutionBoList);

    /**
     * 协议明细价格执行列表查询
     */
    AgrItemListPriceExecutionQryRspPageBo getAgrItemPriceExecutionList(AgrItemListPriceExecutionQryReqPageBo agrItemListQryReqPageBo);

    /**
     * 新增协议主体扩展
     */
    void createAgrMainExt(AgrAgrDo agrAgrDo);

    /**
     * 删除协议主体扩展
     */
    void deleteAgrMainExt(AgrAgrDo agrAgrDo);

    /**
     * 批量新增协议附件
     *
     * @param agrAgrDo
     */
    void insertBatchAgrAccessory(AgrAgrDo agrAgrDo);

    /**
     * 返回协议及协议明细允许商品解冻的协议信息
     *
     * @param agrSyncUccReqBO
     */
    List<AgrItem> checkAgrItemUnfreeze(AgrSyncUccReqBO agrSyncUccReqBO);
    /**
     * 新增协议预警信息
     * @param agrAlertInfoBOList
     */
    void createAgrAlertInfo(List<AgrAlertInfoBO> agrAlertInfoBOList);
    /**
     * 查新协议预警集合
     * @param qryAgrBo
     */
    List<AgrAlertInfoBO> qryAgrAlertInfoList(AgrAlertInfoBO qryAgrBo);
    /**
     * 修改协议预警信息
     * @param agrAlertInfoBOList
     */
    void updateAgrAlertInfo(List<AgrAlertInfoBO> agrAlertInfoBOList);
    void updateAgrAlertStatus(List<AgrAlertInfoBO> agrAlertInfoBOList);

    void updateAgrAlertIsSend(AgrAlertInfoBO reqSetBo,AgrAlertInfoBO reqWhereBo);

    AgrAgrDo getAgrExtList(AgrAgrQryBo agrAgrQryBo);

    AgrQueryAlertStatisticsRspBO queryAlertStatistics(AgrQueryAlertStatisticsReqBO reqBO);
}
