package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrMainReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrMainRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:AgrUpdateAgrMainServiceImpl
 * 说明:TODO
 * 时间:2022/9/22 19:08
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrUpdateAgrMainServiceImpl implements AgrUpdateAgrMainService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Override
    public AgrUpdateAgrMainRspBO updateAgrMain(AgrUpdateAgrMainReqBO agrUpdateAgrMainReqBO) {
        // 1 必填校验
        this.validateParam(agrUpdateAgrMainReqBO);
        // 2 调用协议主体修改
        AgrAgrDo agrAgrDo = JSON.parseObject(JSON.toJSONString(agrUpdateAgrMainReqBO),AgrAgrDo.class) ;
        this.iAgrAgrModel.updateAgrMain(agrAgrDo);
        return AgrRu.success(AgrUpdateAgrMainRspBO.class);
    }
    /**
     * 入参校验
     */
    private void validateParam(AgrUpdateAgrMainReqBO agrUpdateAgrMainReqBO){
        if (ObjectUtil.isEmpty(agrUpdateAgrMainReqBO)){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (agrUpdateAgrMainReqBO.getAgrId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[agrId]不能为空");
        }
    }
}
