package com.tydic.dyc.agr.service.auditorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.service.auditorder.bo.AgrGetAuditObjReqBO;
import com.tydic.dyc.agr.service.auditorder.bo.AgrGetAuditObjRspBO;
import com.tydic.dyc.agr.service.auditorder.bo.AgrUocApprovalObjBo;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:AgrGetAuditObjServiceImpl
 * 说明:TODO
 * 时间:2022/9/23 16:45
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrGetAuditObjServiceImpl implements AgrGetAuditObjService {
    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;
    @Override
    public AgrGetAuditObjRspBO getAuditObj(AgrGetAuditObjReqBO reqBO) {
        AgrAuditOrderQryBo agrAuditOrderQryBo = JSON.parseObject(JSON.toJSONString(reqBO),AgrAuditOrderQryBo.class);
        AgrAuditOrderDo agrAuditOrderDo = this.iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);
        AgrGetAuditObjRspBO rspBO = AgrRu.success(AgrGetAuditObjRspBO.class);
        rspBO.setUocApprovalObj(JSON.parseArray(JSON.toJSONString(agrAuditOrderDo.getUocApprovalObj()), AgrUocApprovalObjBo.class));
        return rspBO;
    }
}
