package com.tydic.dyc.agr.service.domainservice;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.agr.config.AgrIndexConfig;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyListRspBO;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.common.AgrCommonDo;
import com.tydic.dyc.agr.model.common.IAgrCommonModel;
import com.tydic.dyc.agr.model.common.qrybo.AgrChngMsgQryBo;
import com.tydic.dyc.agr.model.common.qrybo.AgrStatusChngRecordQryBo;
import com.tydic.dyc.agr.model.common.sub.AgrAgrChngMsg;
import com.tydic.dyc.agr.model.common.sub.AgrAgrStatusChngRecord;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrTaskQryBo;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrChngMsgDealTimeTaskReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrChngMsgDealTimeTaskRspBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrNoticeReceiverBO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.xcontent.XContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.io.IOException;
import java.util.*;

/**
 * 标题:AgrAgrChngMsgDealTimeTaskServiceImpl
 * 说明:TODO
 * 时间:2023/2/7 17:00
 * 作者:代愿愿
 */
@HTServiceImpl
@Slf4j
public class AgrAgrChngMsgDealTimeTaskServiceImpl implements AgrAgrChngMsgDealTimeTaskService {
    @Autowired
    private IAgrCommonModel iAgrCommonModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    private AgrIndexConfig agrIndexConfig;

    private final String AGR_AUDIT_TERMINATE_TASK_CODE = "agr_audit_termimate_task_code";

    private final String AGR_CHNG_AUDIT_TERMINATE_TASK_CODE = "agr_chng_audit_termimate_task_code";

    @Value("${NOTIFY_URL_INNER}")
    private String NOTICE_URL;

    @Override
    public AgrAgrChngMsgDealTimeTaskRspBO dealAgrChngMsgDealTimeTask(AgrAgrChngMsgDealTimeTaskReqBO timeTaskReqBO) {
        AgrAgrChngMsgDealTimeTaskRspBO rspBO = new AgrAgrChngMsgDealTimeTaskRspBO();
        rspBO.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(AgrRspConstant.RESP_DESC_SUCCESS);
        // 1 查询有效的消息
        AgrChngMsgQryBo agrChngMsgQryBo = new AgrChngMsgQryBo() ;
        agrChngMsgQryBo.setMsgType(timeTaskReqBO.getMsgType());
        agrChngMsgQryBo.setObjType(timeTaskReqBO.getObjType());
        agrChngMsgQryBo.setMsgStatus(AgrCommConstant.agrChngMsgStatus.EFFECTIVE);
        AgrCommonDo agrCommonDo = iAgrCommonModel.getAgrChngMsgList(agrChngMsgQryBo);
        if(!CollectionUtils.isEmpty(agrCommonDo.getAgrAgrChngMsg())){
            for(int i=0;i<agrCommonDo.getAgrAgrChngMsg().size();i++){
                // 更新状态为处理中
                AgrCommonDo agrCommonDo2 = new AgrCommonDo();
                List<AgrAgrChngMsg> agrAgrChngMsgs1 = new ArrayList<>();
                AgrAgrChngMsg agrAgrChngMsg2 = new AgrAgrChngMsg();
                agrAgrChngMsg2.setMsgId(agrCommonDo.getAgrAgrChngMsg().get(i).getMsgId());
                agrAgrChngMsg2.setMsgStatus(AgrCommConstant.agrChngMsgStatus.EFFECTIVEING);
                agrAgrChngMsgs1.add(agrAgrChngMsg2);
                agrCommonDo2.setAgrAgrChngMsg(agrAgrChngMsgs1);
                iAgrCommonModel.updateAgrChngMsg(agrCommonDo2);

                // 2 处理消息
                if(timeTaskReqBO.getMsgType().equals(AgrCommConstant.agrChngMsgType.FROZEN)){
                    // 2-1 处理冻结消息
                    this.frozen(agrCommonDo.getAgrAgrChngMsg().get(i),rspBO);
                }else if(timeTaskReqBO.getMsgType().equals(AgrCommConstant.agrChngMsgType.UN_FROZEN)){
                    // 2-2 处理解冻消息
                    this.unfrozen(agrCommonDo.getAgrAgrChngMsg().get(i),rspBO);
                }
                // 3 更新消息的状态为失效
                AgrCommonDo agrCommonDo1 = new AgrCommonDo();
                List<AgrAgrChngMsg> agrAgrChngMsgs = new ArrayList<>();
                AgrAgrChngMsg agrAgrChngMsg = new AgrAgrChngMsg();
                agrAgrChngMsg.setMsgId(agrCommonDo.getAgrAgrChngMsg().get(i).getMsgId());
                agrAgrChngMsg.setMsgStatus(AgrCommConstant.agrChngMsgStatus.NO_EFFECTIVE);
                agrAgrChngMsgs.add(agrAgrChngMsg);
                agrCommonDo1.setAgrAgrChngMsg(agrAgrChngMsgs);
                iAgrCommonModel.updateAgrChngMsg(agrCommonDo1);
            }
        }
        return rspBO;
    }
    /**
     * 处理解冻逻辑
     */
    private void unfrozen(AgrAgrChngMsg agrAgrChngMsg,AgrAgrChngMsgDealTimeTaskRspBO rspBO){
        List<String> taskIds = new ArrayList<>();
        rspBO.setTaskIds(taskIds);
        // 1 查询冻结前状态
        AgrStatusChngRecordQryBo agrStatusChngRecordQryBo = new AgrStatusChngRecordQryBo();
        agrStatusChngRecordQryBo.setMsgId(agrAgrChngMsg.getRelMsgId());
        AgrCommonDo agrCommonDo = iAgrCommonModel.getAgrStatusChngRecordList(agrStatusChngRecordQryBo);
        if(!CollectionUtils.isEmpty(agrCommonDo.getAgrAgrStatusChngRecord())){
            agrCommonDo.getAgrAgrStatusChngRecord().forEach(agrAgrStatusChngRecord -> {
                // 2 更新状态
                if(ObjectUtils.isEmpty(agrAgrStatusChngRecord.getChngApplyId())){
                    // 2-1 更新协议状态为原状态
                    AgrAgrDo agrAgrDo1 = new AgrAgrDo();
                    agrAgrDo1.setAgrId(agrAgrStatusChngRecord.getAgrId());
                    agrAgrDo1.setAgrStatus(Integer.parseInt(agrAgrStatusChngRecord.getOldStatus()));
                    iAgrAgrModel.updateAgrMain(agrAgrDo1);
                    // 2-2 同步es
                    JSONObject updateJson = new JSONObject();
                    updateJson.put("agrId",agrAgrStatusChngRecord.getAgrId());
                    updateJson.put("agrStatus",Integer.parseInt(agrAgrStatusChngRecord.getOldStatus()));
                    updateJson.put("agrStatusStr", AgrCommConstant.AgreementStatusEnum.getNameByValue(Integer.parseInt(agrAgrStatusChngRecord.getOldStatus())));
                    updateDoc(agrIndexConfig.getAgrIndex(),agrAgrStatusChngRecord.getAgrId().toString(),updateJson);

                    if(AgrCommConstant.AgreementStatus.IN_AUDIT.equals(Integer.parseInt(agrAgrStatusChngRecord.getOldStatus()))){
                        // 如果原状态为审批中，需要重新启动一个审批流,查询业务流，提交业务的环节自动启一个审批流
                        AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
                        agrTaskQryBo.setOrderId(agrAgrStatusChngRecord.getAgrId());
                        agrTaskQryBo.setFinishTag(0);
                        agrTaskQryBo.setObjType(AgrCommConstant.ObjType.AGREEMENT);
                        AgrProcInstDo agrProcInstDo = iAgrProcInstModel.getTaskList(agrTaskQryBo);
                        if(!CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskInst())){
                            taskIds.add(agrProcInstDo.getAgrUocOrderTaskInst().get(0).getTaskInstId());
                        }

                    }
                }else {
                    // 2-3 更新协议变更状态为原状态
                    AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
                    agrChngApplyDo.setAgrId(agrAgrStatusChngRecord.getAgrId());
                    agrChngApplyDo.setChngApplyId(agrAgrStatusChngRecord.getChngApplyId());
                    agrChngApplyDo.setChngApplyStatus(Integer.parseInt(agrAgrStatusChngRecord.getOldStatus()));
                    iAgrChngApplyModel.updateAgrChngApplyMain(agrChngApplyDo);
                    // 2-4 同步es
                    JSONObject updateJson = new JSONObject();
                    updateJson.put("chngApplyId",agrAgrStatusChngRecord.getChngApplyId());
                    updateJson.put("chngApplyStatus",Integer.parseInt(agrAgrStatusChngRecord.getOldStatus()));
                    updateJson.put("chngApplyStatusStr", AgrCommConstant.ChngApplyStatusEnum.getNameByValue(Integer.parseInt(agrAgrStatusChngRecord.getOldStatus())));
                    updateDoc(agrIndexConfig.getAgrIndex(),agrAgrStatusChngRecord.getChngApplyId().toString(),updateJson);

                    if(AgrCommConstant.ChangeApplyStatus.IN_AUDIT.equals(Integer.parseInt(agrAgrStatusChngRecord.getOldStatus()))){
                        // 如果原状态为审批中，需要重新启动一个审批流
                        AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
                        agrTaskQryBo.setOrderId(agrAgrStatusChngRecord.getAgrId());
                        agrTaskQryBo.setFinishTag(0);
                        agrTaskQryBo.setObjType(AgrCommConstant.ObjType.CHANGE);
                        AgrProcInstDo agrProcInstDo = iAgrProcInstModel.getTaskList(agrTaskQryBo);
                        if(!CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskInst())){
                            taskIds.add(agrProcInstDo.getAgrUocOrderTaskInst().get(0).getTaskInstId());
                        }
                    }
                }
            });
        }

    }
    /**
     * 处理冻结逻辑
     */
    private void frozen(AgrAgrChngMsg agrAgrChngMsg,AgrAgrChngMsgDealTimeTaskRspBO rspBO){
        // 1 查询供应商的所有协议
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo() ;
        agrAgrQryBo.setSupplierId(agrAgrChngMsg.getObjId());
        AgrGetAgrMainListRspQryBo agrGetAgrMainListRspQryBo = iAgrAgrModel.getAgrMainList(agrAgrQryBo);
        if(!CollectionUtils.isEmpty(agrGetAgrMainListRspQryBo.getRows())){
            List<AgrAgrDo> agr = agrGetAgrMainListRspQryBo.getRows();
            agr.forEach(agrAgrDo -> {
                if(agrAgrDo.getAgrStatus().equals(AgrCommConstant.AgreementStatus.IN_AUDIT)){
                    // 拼装通知消息
                    List<AgrNoticeReceiverBO> agrNoticeReceiverBOs = new ArrayList<>();
                    AgrNoticeReceiverBO agrNoticeReceiverBO = new AgrNoticeReceiverBO();
                    agrNoticeReceiverBO.setReceiverId(agrAgrDo.getAgrOperatorId().toString());
                    agrNoticeReceiverBO.setReceiverName(agrAgrDo.getAgrOperatorName());
                    agrNoticeReceiverBOs.add(agrNoticeReceiverBO);
                    JSONObject reqJson = new JSONObject();
                    JSONObject data = new JSONObject();
                    data.put("agrCode",agrAgrDo.getAgrCode());
                    data.put("supplierName",agrAgrDo.getSupplierName());
                    reqJson.put("sendId",1);
                    reqJson.put("sendName","admin");
                    reqJson.put("taskCode",AGR_AUDIT_TERMINATE_TASK_CODE);
                    reqJson.put("receivers",agrNoticeReceiverBOs);
                    reqJson.put("data",data.toJSONString());
                    log.info("消息发送内容"+reqJson.toJSONString());
                    String result = HttpUtil.post(NOTICE_URL, reqJson.toJSONString());
                    log.info("消息发送结果"+result);
                }

                AgrCommonDo agrCommonDo = new AgrCommonDo();
                List<AgrAgrStatusChngRecord> agrAgrStatusChngRecords = new ArrayList<>();
                // 2 查询协议下的变更申请
                AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new AgrAgrChngApplyQryBo();
                agrAgrChngApplyQryBo.setAgrId(agrAgrDo.getAgrId());
                AgrAgrChngApplyListRspBO agrAgrChngApplyListRspBO = iAgrChngApplyModel.getAgrChngApplyList(agrAgrChngApplyQryBo);
                if(!CollectionUtils.isEmpty(agrAgrChngApplyListRspBO.getAgrChngApply())){
                    agrAgrChngApplyListRspBO.getAgrChngApply().forEach(agrChngApply -> {
                        if(!agrChngApply.getChngApplyStatus().equals(AgrCommConstant.ChangeApplyStatus.PASS.toString())){
                            if(agrChngApply.getChngApplyStatus().equals(AgrCommConstant.ChangeApplyStatus.IN_AUDIT.toString())){
                                // 如果状态为审批中，需要发通知
                                // 拼装通知消息
                                List<AgrNoticeReceiverBO> agrNoticeReceiverBOs = new ArrayList<>();
                                AgrNoticeReceiverBO agrNoticeReceiverBO = new AgrNoticeReceiverBO();
                                agrNoticeReceiverBO.setReceiverId(agrChngApply.getCreateLoginId().toString());
                                agrNoticeReceiverBO.setReceiverName(agrChngApply.getCreateName());
                                agrNoticeReceiverBOs.add(agrNoticeReceiverBO);
                                JSONObject reqJson = new JSONObject();
                                JSONObject data = new JSONObject();
                                data.put("agrCode",agrAgrDo.getAgrCode());
                                data.put("supplierName",agrAgrDo.getSupplierName());
                                reqJson.put("sendId",1);
                                reqJson.put("sendName","admin");
                                reqJson.put("taskCode",AGR_CHNG_AUDIT_TERMINATE_TASK_CODE);
                                reqJson.put("receivers",agrNoticeReceiverBOs);
                                reqJson.put("data",data.toJSONString());
                                log.info("消息发送内容"+reqJson.toJSONString());
                                String result = HttpUtil.post(NOTICE_URL, reqJson.toJSONString());
                                log.info("消息发送结果"+result);
                            }

                            // 3 不为审批通过的协议变更申请都要冻结
                            AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
                            agrChngApplyDo.setAgrId(agrAgrDo.getAgrId());
                            agrChngApplyDo.setChngApplyId(agrChngApply.getChngApplyId());
                            agrChngApplyDo.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.FROZEN);
                            iAgrChngApplyModel.updateAgrChngApplyMain(agrChngApplyDo);
                            // 同步协议变更ES
                            JSONObject updateJson = new JSONObject();
                            updateJson.put("chngApplyId",agrChngApply.getChngApplyId());
                            updateJson.put("chngApplyStatus",AgrCommConstant.ChangeApplyStatus.FROZEN);
                            updateJson.put("chngApplyStatusStr", AgrCommConstant.ChngApplyStatusEnum.getNameByValue(AgrCommConstant.ChangeApplyStatus.FROZEN));
                            updateDoc(agrIndexConfig.getAgrIndex(),agrChngApply.getChngApplyId().toString(),updateJson);


                            AgrAgrStatusChngRecord agrAgrStatusChngRecord = new AgrAgrStatusChngRecord();
                            agrAgrStatusChngRecord.setAgrId(agrAgrDo.getAgrId());
                            agrAgrStatusChngRecord.setId(Sequence.getInstance().nextId());
                            agrAgrStatusChngRecord.setCreateTime(new Date());
                            agrAgrStatusChngRecord.setOldStatus(agrChngApply.getChngApplyStatus());
                            agrAgrStatusChngRecord.setCurrentStatus(AgrCommConstant.ChangeApplyStatus.FROZEN.toString());
                            agrAgrStatusChngRecord.setMsgId(agrAgrChngMsg.getMsgId());
                            agrAgrStatusChngRecord.setChngApplyId(agrChngApply.getChngApplyId());
                            agrAgrStatusChngRecords.add(agrAgrStatusChngRecord);
                        }
                    });
                }
                // 4 更新协议状态为冻结
                AgrAgrDo agrAgrDo1 = new AgrAgrDo();
                agrAgrDo1.setAgrId(agrAgrDo.getAgrId());
                agrAgrDo1.setAgrStatus(AgrCommConstant.AgreementStatus.FROZEN);
                iAgrAgrModel.updateAgrMain(agrAgrDo1);
                // 同步协议ES
                JSONObject updateJson = new JSONObject();
                updateJson.put("agrId",agrAgrDo.getAgrId());
                updateJson.put("agrStatus",AgrCommConstant.AgreementStatus.FROZEN);
                updateJson.put("agrStatusStr", AgrCommConstant.AgreementStatusEnum.getNameByValue(AgrCommConstant.AgreementStatus.FROZEN));
                updateDoc(agrIndexConfig.getAgrIndex(),agrAgrDo.getAgrId().toString(),updateJson);

                AgrAgrStatusChngRecord agrAgrStatusChngRecord = new AgrAgrStatusChngRecord();
                agrAgrStatusChngRecord.setAgrId(agrAgrDo.getAgrId());
                agrAgrStatusChngRecord.setId(Sequence.getInstance().nextId());
                agrAgrStatusChngRecord.setCreateTime(new Date());
                agrAgrStatusChngRecord.setOldStatus(agrAgrDo.getAgrStatus().toString());
                agrAgrStatusChngRecord.setCurrentStatus(AgrCommConstant.AgreementStatus.FROZEN.toString());
                agrAgrStatusChngRecord.setMsgId(agrAgrChngMsg.getMsgId());
                agrAgrStatusChngRecords.add(agrAgrStatusChngRecord);
                // 5 新增状态变更记录，记录冻结前的状态
                agrCommonDo.setAgrAgrStatusChngRecord(agrAgrStatusChngRecords);
                iAgrCommonModel.savaAgrStatusChngRecord(agrCommonDo);
                // 6 查询审批流
                AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
                agrTaskQryBo.setOrderId(agrAgrDo.getAgrId());
                agrTaskQryBo.setFinishTag(0);
                agrTaskQryBo.setObjType(AgrCommConstant.ObjType.APPROVE);
                AgrProcInstDo agrProcInstDo = iAgrProcInstModel.getTaskList(agrTaskQryBo);
                if(!CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskInst())){
                    // 7 终止审批流
                    this.dealAuditProcess(agrProcInstDo.getAgrUocOrderTaskInst(),rspBO);
                }

            });
        }

    }
    private void dealAuditProcess(List<UocOrderTaskInst> agrUocOrderTaskInst,AgrAgrChngMsgDealTimeTaskRspBO rspBO){
        Set<String> procInstIdset = new HashSet<>();
        agrUocOrderTaskInst.forEach(agrUocOrderTaskInst1->{
            procInstIdset.add(agrUocOrderTaskInst1.getProcInstId());
        });
        List<String> taskIds = new ArrayList<>();
        agrUocOrderTaskInst.forEach(mmcShopTaskInstBO1 -> {
            taskIds.add(mmcShopTaskInstBO1.getTaskInstId());
        });
        //1 删除待办任务
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        List<UocOrderTaskInst> agrUocOrderTaskInst1 = new ArrayList<>();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setOrderId(agrUocOrderTaskInst.get(0).getOrderId());
        uocOrderTaskInst.setTaskInstIds(taskIds);
        agrUocOrderTaskInst1.add(uocOrderTaskInst);
        agrProcInstDo.setAgrUocOrderTaskInst(agrUocOrderTaskInst1);
        iAgrProcInstModel.deleteTask(agrProcInstDo);
        // 暂时不给审批人处理人发通知
        /*//2 查询任务处理人
        List<AgrNoticeReceiverBO> receivers = new ArrayList<>();
        AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
        agrTaskQryBo.setOrderId(agrUocOrderTaskInst.get(0).getOrderId());
        agrTaskQryBo.setTaskInstIds(taskIds);
        AgrProcInstDo agrProcInstDo1 = iAgrProcInstModel.getTaskDeal(agrTaskQryBo);
        if(!CollectionUtils.isEmpty(agrProcInstDo1.getAgrUocOrderTaskDeal())){
            //3 发送通知给任务处理人
            agrProcInstDo1.getAgrUocOrderTaskDeal().forEach(uocOrderTaskDeal -> {
                AgrNoticeReceiverBO bo = new AgrNoticeReceiverBO();
                bo.setReceiverId(uocOrderTaskDeal.getDealId());
                bo.setReceiverName(uocOrderTaskDeal.getDealName());
                receivers.add(bo);
            });
        }
        rspBO.setAgrNoticeReceiverBO(receivers);*/
        rspBO.setProcInstIds(new ArrayList<>(procInstIdset));

    }
    /**
     * 更新ES
     */
    public void updateDoc(String indexName, String docId, JSONObject source) {
        log.info("根据文章ID更新文章，入参：indexName = '{}', docId = '{}'", indexName, docId);
        UpdateRequest request = new UpdateRequest(indexName, docId);
        // 在版本冲突，更新失败时，重试3次。
        request.retryOnConflict(3);
        request.doc(JSON.toJSONString(source), XContentType.JSON);
        try {
            UpdateResponse response = restHighLevelClient.update(request, RequestOptions.DEFAULT);
            // UPDATED和NOOP都视为成功
            if (DocWriteResponse.Result.UPDATED.equals(response.getResult())
                    || DocWriteResponse.Result.NOOP.equals(response.getResult())) {
                log.info("文章更新成功");
                return;
            }
            throw new BaseBusinessException(BaseRspConstant.RSP_CODE_FAIL, "根据文章ID更新文章失败：" + response.getResult());
        } catch (IOException e) {
            log.error("根据文章ID更新文章异常：" + e);
            throw new BaseBusinessException(BaseRspConstant.RSP_CODE_FAIL, "根据文章ID更新文章异常：" + e.getMessage());
        }
    }

}
