/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.sub.AgrAccessory;
import com.tydic.dyc.agr.model.agr.sub.AgrAdjustCfg;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.model.agr.sub.AgrCataScope;
import com.tydic.dyc.agr.model.agr.sub.AgrMainExt;
import com.tydic.dyc.agr.model.agr.sub.AgrPayConfig;
import com.tydic.dyc.agr.model.agr.sub.AgrRel;
import com.tydic.dyc.agr.service.agr.AgrCreateAgrService;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrRspBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrCreateAgrService"})
public class AgrCreateAgrServiceImpl
implements AgrCreateAgrService {
    private static final Logger log = LoggerFactory.getLogger(AgrCreateAgrServiceImpl.class);
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"createAgr"})
    public AgrCreateAgrRspBo createAgr(@RequestBody AgrCreateAgrReqBo reqBo) {
        log.debug("\u521b\u5efa\u534f\u8bae\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBo));
        this.validateParams(reqBo);
        AgrAgrDo agrAgrDo = this.setCreationInformation(reqBo);
        this.iAgrAgrModel.createAgr(agrAgrDo);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAgrItem())) {
            AgrAgrDo agrAgrDo1 = (AgrAgrDo)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBo), AgrAgrDo.class);
            agrAgrDo1.setAgrId(agrAgrDo.getAgrId());
            this.iAgrAgrModel.saveAgrItem(agrAgrDo1);
        }
        AgrCreateAgrRspBo rspBo = AgrRu.success(AgrCreateAgrRspBo.class);
        rspBo.setAgrId(agrAgrDo.getAgrId());
        return rspBo;
    }

    private AgrAgrDo setCreationInformation(AgrCreateAgrReqBo reqBo) {
        AgrPayConfig agrPayConfig;
        AgrAgrDo agrAgrDo = (AgrAgrDo)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBo.getAgrMainSaveBO()), AgrAgrDo.class);
        agrAgrDo.setOperTime(new Date());
        agrAgrDo.setUserId(reqBo.getUserId());
        agrAgrDo.setUsername(reqBo.getAgrMainSaveBO().getCreateName());
        agrAgrDo.setCreateName(reqBo.getAgrMainSaveBO().getCreateName());
        agrAgrDo.setName(reqBo.getAgrMainSaveBO().getCreateName());
        agrAgrDo.setOrgId(reqBo.getOrgId());
        agrAgrDo.setOrgName(reqBo.getOrgName());
        agrAgrDo.setVendorMode(reqBo.getAgrMainSaveBO().getSupplierMode());
        agrAgrDo.setOrgPath(reqBo.getOrgPath());
        agrAgrDo.setAgrAccessory(AgrRu.jsl(reqBo.getAgrAccessoryBOs(), AgrAccessory.class));
        agrAgrDo.setAgrAppScope(AgrRu.jsl(reqBo.getAgrAppScopeBOs(), AgrAppScope.class));
        agrAgrDo.setAgrCataScope(AgrRu.jsl(reqBo.getAgrCataScopeBOs(), AgrCataScope.class));
        ArrayList<AgrPayConfig> agrPayConfigList = new ArrayList<AgrPayConfig>();
        if (ObjectUtil.isNotEmpty((Object)reqBo.getAgrMainSaveBO().getPayTypeSup()) && ObjectUtil.isNotEmpty((Object)reqBo.getAgrMainSaveBO().getPayTypeSup().getPayType())) {
            agrPayConfig = AgrRu.js(reqBo.getAgrMainSaveBO().getPayTypeSup(), AgrPayConfig.class);
            agrPayConfig.setPayObj(AgrCommConstant.payObj.PAY_OBJ_SUPPLY);
            agrPayConfigList.add(agrPayConfig);
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getAgrMainSaveBO().getPayTypePur()) && ObjectUtil.isNotEmpty((Object)reqBo.getAgrMainSaveBO().getPayTypePur().getPayType())) {
            agrPayConfig = AgrRu.js(reqBo.getAgrMainSaveBO().getPayTypePur(), AgrPayConfig.class);
            agrPayConfig.setPayObj(AgrCommConstant.payObj.PAY_OBJ_PURCHASE);
            agrPayConfigList.add(agrPayConfig);
        }
        agrAgrDo.setAgrPayConfig(agrPayConfigList);
        AgrAdjustCfg agrAdjustCfg = new AgrAdjustCfg();
        agrAdjustCfg.setAdjustPrice(reqBo.getAgrMainSaveBO().getAdjustPrice());
        agrAgrDo.setAgrAdjustCfg(agrAdjustCfg);
        ArrayList<AgrRel> agrRels = new ArrayList<AgrRel>();
        if (ObjectUtil.isNotEmpty((Object)reqBo.getAgrRel())) {
            reqBo.getAgrRel().forEach(r -> {
                AgrRel agrRel = AgrRu.js(r, AgrRel.class);
                agrRels.add(agrRel);
            });
            agrAgrDo.setAgrRel(agrRels);
        }
        if (null != agrAgrDo.getAgrBusinessType()) {
            agrAgrDo.setAgrType(AgrCommConstant.AgrType.SELF_AGR);
            agrAgrDo.setWhetherHaveItem(AgrCommConstant.WhetherHaveItemEnum.WHETHER_HAVE_ITEM_NO.getValue());
            ArrayList<AgrMainExt> agrMainExtBOs = new ArrayList<AgrMainExt>();
            AgrMainExt agrMainExtBo1 = new AgrMainExt();
            agrMainExtBo1.setFieldCode("agrOperatorId");
            agrMainExtBo1.setFieldName("\u7ecf\u529e\u4ebaid");
            agrMainExtBo1.setFieldValue(reqBo.getAgrMainSaveBO().getAgrOperatorId().toString());
            agrMainExtBo1.setRemark("1");
            agrMainExtBOs.add(agrMainExtBo1);
            AgrMainExt agrMainExtBo2 = new AgrMainExt();
            agrMainExtBo2.setFieldCode("agrOperatorName");
            agrMainExtBo2.setFieldName("\u7ecf\u529e\u4eba\u771f\u5b9e\u59d3\u540d");
            agrMainExtBo2.setFieldValue(reqBo.getAgrMainSaveBO().getAgrOperatorName());
            agrMainExtBo2.setRemark("1");
            agrMainExtBOs.add(agrMainExtBo2);
            AgrMainExt agrMainExtBo3 = new AgrMainExt();
            agrMainExtBo3.setFieldCode("agrOperatorUserName");
            agrMainExtBo3.setFieldName("\u7ecf\u529e\u4eba\u8d26\u53f7");
            agrMainExtBo3.setFieldValue(reqBo.getAgrMainSaveBO().getAgrOperatorUsername());
            agrMainExtBo3.setRemark("1");
            agrMainExtBOs.add(agrMainExtBo3);
            agrAgrDo.setAgrMainExtBOs(agrMainExtBOs);
        } else {
            agrAgrDo.setAgrBusinessType(AgrCommConstant.AgrBusinessType.ENTERPRISE_PROCUREMENT);
            agrAgrDo.setAgrType(AgrCommConstant.AgrType.AGR);
            agrAgrDo.setWhetherHaveItem(AgrCommConstant.WhetherHaveItemEnum.WHETHER_HAVE_ITEM_YES.getValue());
            agrAgrDo.setScopeType(AgrCommConstant.ScopeType.DESINGATE_UNIT);
            agrAgrDo.setPurType(reqBo.getAgrMainSaveBO().getPurType());
        }
        agrAgrDo.setCreateCompanyIds(reqBo.getAgrMainSaveBO().getCreateCompanyIds());
        agrAgrDo.setCreateCompanyNames(reqBo.getAgrMainSaveBO().getCreateCompanyNames());
        agrAgrDo.setCreateOrgTreePaths(reqBo.getAgrMainSaveBO().getCreateOrgTreePaths());
        return agrAgrDo;
    }

    private void validateParams(AgrCreateAgrReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo.getAgrMainSaveBO())) {
            throw new BaseBusinessException("", "\u5165\u53c2\u5bf9\u8c61[\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAgrMainSaveBO().getAgrCode())) {
            throw new BaseBusinessException("", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8bae\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

