package com.tydic.dyc.agr.model.sysDicDictionary;

import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.AgrDictionaryRspBo;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.SysDicDictionaryRspBo;

import java.util.List;
import java.util.Map;

/**
 * @Description: IAgrDictionaryModel
 * @Author: the_xhl
 * @Date: 2023-07-27
 */
public interface IAgrDictionaryModel {

    List<DicDictionaryBo> selectByPCodeList(List<String> pCodeList);

    /**
     * Map<pCode, Map<code, AgrDicDictionaryBo>>
     *
     * @param pCodeList pCodeList
     * @return {@link Map}<{@link String}, {@link Map}<{@link String}, {@link List}<{@link DicDictionaryBo}>>>
     */
    Map<String, Map<String, DicDictionaryBo>> selectByPCodeListToMap(List<String> pCodeList);
    /**
     * 根据入参条件查询字典
     */
    SysDicDictionaryDo getDictionaryByDo(SysDicDictionaryDo dicDictionaryDo);
    /**
     * 新增字典
     */
    void addDicDictionary(SysDicDictionaryDo sysDicDictionaryDo);
    /**
     * 删除字典
     */
    void deleteDicDictionary(SysDicDictionaryDo dicDictionaryBO);
    /**查询字典Map
     * @param sysDicDictionaryDo
     * @return
     */
    AgrDictionaryRspBo queryBypCodeBackMap(SysDicDictionaryDo sysDicDictionaryDo);
    /**根据Pcode查询字典集合
     * @param dicDictionaryDo
     * @return
     */
    SysDicDictionaryRspBo queryBypCodeBackPo(SysDicDictionaryDo dicDictionaryDo);
    /**
     * 修改字典
     * @param dicDictionaryBO
     * @return
     */
    void updateDicDictionary(SysDicDictionaryDo dicDictionaryBO);
}
