package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrInvalidReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrInvalidRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMainListBo;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description: AgrReferenceInvalidServiceImpl
 * @Author: the_xhl
 * @Date: 2023-07-28
 */
@HTServiceImpl
public class AgrAgrInvalidServiceImpl implements AgrAgrInvalidService {

    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrInvalidRspBO dealAgrInvalid(AgrInvalidReqBO agrInvalidReqBO) {
        this.check(agrInvalidReqBO);
        AgrInvalidRspBO rspBO = AgrRu.success(AgrInvalidRspBO.class);
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(agrInvalidReqBO.getAgrId());
        AgrGetAgrMainListRspQryBo dealRefRsp = this.iAgrAgrModel.dealAgrInvalid(agrAgrDo);
        rspBO.setAgrMainList(AgrRu.jsl(dealRefRsp.getRows(), AgrMainListBo.class));
        return rspBO;
    }

    private void check(AgrInvalidReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
    }
}
