package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.bo.AgrCheckAgrAppScopeReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCheckAgrAppScopeRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCheckScopeBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @ClassName AgrCheckAgrAppScopeServiceImpl
 * @Author 14051
 * @Date 2024/3/4 15:37
 * @Version 1.0
 * @Description 根据协议ID集合校验是否满足所给的应用范围实现类
 **/
@Slf4j
@HTServiceImpl
public class AgrCheckAgrAppScopeServiceImpl implements AgrCheckAgrAppScopeService {

    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrCheckAgrAppScopeRspBO checkAgrAppScope(AgrCheckAgrAppScopeReqBO reqBO) {
        validParam(reqBO);
        List<AgrCheckScopeBO> agrCheckScopeBOS = new ArrayList<>();
        List<String> scopeCodes = new ArrayList<>();
        if (!ObjectUtil.isEmpty(reqBO.getOrgTreePathIn())){
            scopeCodes = Arrays.asList(reqBO.getOrgTreePathIn().split("-"));
        }
        if (!CollectionUtils.isEmpty(reqBO.getAgrIds())) {
            checkAgrScope(reqBO, agrCheckScopeBOS,scopeCodes);
        }
        //框架协议适用范围控制在协议明细上，不存在全平台，只有指定单位
        else if (!CollectionUtils.isEmpty(reqBO.getAgrItemIds())) {
            agrCheckScopeBOS = new ArrayList<>();
            checkAgrItemScope(reqBO, agrCheckScopeBOS,scopeCodes);
        }
        //返回
        AgrCheckAgrAppScopeRspBO rspBO = new AgrCheckAgrAppScopeRspBO();
        rspBO.setRows(agrCheckScopeBOS);
        return rspBO;
    }

    /**
     * 校验协议适用范围
     *
     * @param reqBO
     * @param agrCheckScopeBOS
     */
    private void checkAgrScope(AgrCheckAgrAppScopeReqBO reqBO, List<AgrCheckScopeBO> agrCheckScopeBOS,List<String> scopeCodes) {
        //根据入参查询协议名称放到map
        Map<Long, String> agrMap = new HashMap<>();
        AgrAgrQryBo qryAgrMainList = new AgrAgrQryBo();
        qryAgrMainList.setAgrIds(reqBO.getAgrIds());
        qryAgrMainList.setPageNo(-1);
        qryAgrMainList.setPageSize(-1);
        AgrGetAgrMainListRspQryBo agrGetAgrMainListRspQryBo = iAgrAgrModel.getAgrMainList(qryAgrMainList);
        if (!CollectionUtils.isEmpty(agrGetAgrMainListRspQryBo.getRows())) {
            agrMap = agrGetAgrMainListRspQryBo.getRows().stream().collect(Collectors.toMap(AgrAgrDo::getAgrId, AgrAgrDo::getAgrName));
        }
        //第一步查询全平台后过滤的
        List<Long> otherAgrIds = new ArrayList<>();
        //第二步根据指定范围ID查询后过滤的
        List<Long> lastAgrIds = new ArrayList<>();
        //先查询是全平台的应用范围，返回true
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrIds(reqBO.getAgrIds());
        agrAgrQryBo.setScopeType(AgrCommConstant.ScopeType.ALL);
        List<AgrAppScope> agrAppScopes = iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo);
        if (!CollectionUtils.isEmpty(agrAppScopes)) {
            agrAppScopes.forEach(bo -> {
                AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                agrCheckScopeBO.setAgrId(bo.getAgrId());
                agrCheckScopeBO.setCheckFlag(true);
                agrCheckScopeBOS.add(agrCheckScopeBO);
            });

            //过滤剩下的协议ID，放入otherAgrIds集合
            otherAgrIds = reqBO.getAgrIds().stream()
                    .filter(agrId -> agrAppScopes.stream().noneMatch(a -> a.getAgrId().equals(agrId)))
                    .collect(Collectors.toList());
        } else {
            //未查询到全平台范围的则放入入参集合
            otherAgrIds = reqBO.getAgrIds();
        }
        //根据指定范围ID查询
        if (!CollectionUtils.isEmpty(otherAgrIds)) {
            agrAgrQryBo = new AgrAgrQryBo();
            agrAgrQryBo.setAgrIds(otherAgrIds);
//            agrAgrQryBo.setScopeCode(reqBO.getScopeId().toString());
            agrAgrQryBo.setScopeCodes(scopeCodes);
            agrAgrQryBo.setAgrType(AgrCommConstant.AgrType.SELF_AGR);
            List<AgrAppScope> otherAgrAppScopes = iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo);
            if (!CollectionUtils.isEmpty(otherAgrAppScopes)) {
                otherAgrAppScopes.forEach(bo -> {
                    AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                    agrCheckScopeBO.setAgrId(bo.getAgrId());
                    agrCheckScopeBO.setCheckFlag(true);
                    agrCheckScopeBOS.add(agrCheckScopeBO);
                });

                lastAgrIds = otherAgrIds.stream()
                        .filter(agrId -> otherAgrAppScopes.stream().noneMatch(a -> a.getAgrId().equals(agrId)))
                        .collect(Collectors.toList());
            } else {
                lastAgrIds = otherAgrIds;
            }
        }

        if (!CollectionUtils.isEmpty(lastAgrIds)) {
            lastAgrIds.forEach(agrId -> {
                AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                agrCheckScopeBO.setAgrId(agrId);
                agrCheckScopeBO.setCheckFlag(false);
                agrCheckScopeBOS.add(agrCheckScopeBO);
            });
        }
        //协议名称赋值
        for (AgrCheckScopeBO bo : agrCheckScopeBOS) {
            if (agrMap != null && agrMap.containsKey(bo.getAgrId())) {
                bo.setAgrName(agrMap.get(bo.getAgrId()));
            }
        }
    }

    /**
     * 校验协议明细适用范围
     *
     * @param reqBO
     * @param agrCheckScopeBOS
     */
    private void checkAgrItemScope(AgrCheckAgrAppScopeReqBO reqBO, List<AgrCheckScopeBO> agrCheckScopeBOS,List<String> scopeCodes) {
        List<AgrCheckScopeBO> tempAgrCheckScopeBOS = new ArrayList<>();
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
        agrItemListQryReqPageBo.setAgrItemIds(reqBO.getAgrItemIds());
        agrItemListQryReqPageBo.setPageNo(-1);
        agrItemListQryReqPageBo.setPageSize(-1);
        //调用协议明细列表查询方法
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.qryAgrItemList(agrItemListQryReqPageBo);

        //查询协议名称放到map
        Map<Long, String> agrMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(agrItemListQryRspPageBo.getRows())) {
            List<Long> agrIds = agrItemListQryRspPageBo.getRows().stream().map(AgrItem::getAgrId).distinct().collect(Collectors.toList());
            AgrAgrQryBo qryAgrMainList = new AgrAgrQryBo();
            qryAgrMainList.setAgrIds(agrIds);
            qryAgrMainList.setPageNo(-1);
            qryAgrMainList.setPageSize(-1);
            AgrGetAgrMainListRspQryBo agrGetAgrMainListRspQryBo = iAgrAgrModel.getAgrMainList(qryAgrMainList);
            if (!CollectionUtils.isEmpty(agrGetAgrMainListRspQryBo.getRows())) {
                agrMap = agrGetAgrMainListRspQryBo.getRows().stream().collect(Collectors.toMap(AgrAgrDo::getAgrId, AgrAgrDo::getAgrName));
            }
        }
        //第一步查询全平台后过滤的
        List<Long> otherAgrItemIds = new ArrayList<>();
        //根据指定范围ID查询后过滤的
        List<Long> lastAgrItemIds = new ArrayList<>();

        //先查询是全平台的应用范围，返回true
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrItemIds(reqBO.getAgrItemIds());
        agrAgrQryBo.setScopeType(AgrCommConstant.ScopeType.ALL);
        List<AgrAppScope> agrAppScopes = iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo);
        if (!CollectionUtils.isEmpty(agrAppScopes)) {
            agrAppScopes.forEach(bo -> {
                AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                agrCheckScopeBO.setAgrId(bo.getAgrId());
                agrCheckScopeBO.setAgrItemId(bo.getAgrItemId());
                agrCheckScopeBO.setCheckFlag(true);
                tempAgrCheckScopeBOS.add(agrCheckScopeBO);
            });

            //过滤剩下的协议ID，放入otherAgrItemIds集合
            otherAgrItemIds = reqBO.getAgrItemIds().stream()
                    .filter(agrItemId -> agrAppScopes.stream().noneMatch(a -> a.getAgrItemId().equals(agrItemId)))
                    .collect(Collectors.toList());
        } else {
            //未查询到全平台范围的则放入入参集合
            otherAgrItemIds = reqBO.getAgrItemIds();
        }
        //根据指定范围ID查询
        if (!CollectionUtils.isEmpty(otherAgrItemIds)) {
            AgrAgrQryBo agrAgrQryBo1 = new AgrAgrQryBo();
            agrAgrQryBo1.setAgrItemIds(reqBO.getAgrItemIds());
//            agrAgrQryBo1.setScopeCode(reqBO.getScopeId().toString());
            agrAgrQryBo1.setScopeCodes(scopeCodes);
            agrAgrQryBo.setAgrType(AgrCommConstant.AgrType.AGR);
            List<AgrAppScope> otherAgrAppScopes = iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo1);
            if (!CollectionUtils.isEmpty(otherAgrAppScopes)) {
                otherAgrAppScopes.forEach(bo -> {
                    AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                    agrCheckScopeBO.setAgrId(bo.getAgrId());
                    agrCheckScopeBO.setAgrItemId(bo.getAgrItemId());
                    agrCheckScopeBO.setCheckFlag(true);
                    tempAgrCheckScopeBOS.add(agrCheckScopeBO);
                });

                lastAgrItemIds = reqBO.getAgrItemIds().stream()
                        .filter(agrItemId -> otherAgrAppScopes.stream().noneMatch(a -> a.getAgrItemId().equals(agrItemId)))
                        .collect(Collectors.toList());
            } else {
                lastAgrItemIds = reqBO.getAgrItemIds();
            }
        }

        if (!CollectionUtils.isEmpty(lastAgrItemIds)) {
            lastAgrItemIds.forEach(agrItemId -> {
                AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                agrCheckScopeBO.setAgrItemId(agrItemId);
                agrCheckScopeBO.setCheckFlag(false);
                tempAgrCheckScopeBOS.add(agrCheckScopeBO);
            });
        }
        //协议名称赋值
        for (AgrCheckScopeBO bo : agrCheckScopeBOS) {
            if (agrMap != null && agrMap.containsKey(bo.getAgrId())) {
                bo.setAgrName(agrMap.get(bo.getAgrId()));
            }
        }
        log.debug("tempAgrCheckScopeBOS:" + JSON.toJSONString(tempAgrCheckScopeBOS));
        //通过协议明细ID去重(会员通过外部机构编码导致一个编码查出多个机构)
        Set<Long> seenAgrItemIds = new HashSet<>();
        for (AgrCheckScopeBO agrCheckScopeBO : tempAgrCheckScopeBOS) {
            if (!seenAgrItemIds.contains(agrCheckScopeBO.getAgrItemId())) {
                seenAgrItemIds.add(agrCheckScopeBO.getAgrItemId());
                agrCheckScopeBOS.add(agrCheckScopeBO);
            }
        }
        log.debug("agrCheckScopeBOS:" + JSON.toJSONString(agrCheckScopeBOS));
    }

    private void validParam(AgrCheckAgrAppScopeReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_OBJ_EMPTY_ERROR, "入参对象为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getAgrIds()) && CollectionUtils.isEmpty(reqBO.getAgrItemIds())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参协议ID集合和协议明细ID集合不能同时为空！");
        }
        /*if (reqBO.getScopeId() == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参范围ID为空！");
        }*/
        if (ObjectUtil.isEmpty(reqBO.getOrgTreePathIn())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参单位树路径错误");
        }
    }
}
