package com.tydic.dyc.agr.service.agr;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.impl.IAgrAgrModelImpl;
import com.tydic.dyc.agr.model.agr.sub.AgrMainExt;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrOperatorBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrOperatorReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrOperatorRspBo;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 标题：AgrCreateAgrOperatorServiceImpl
 * 说明：维护协议经办人服务实现
 * 时间：2024/7/12 14:17
 *
 * @author 周钰焱
 */
@HTServiceImpl
public class AgrCreateAgrOperatorServiceImpl implements AgrCreateAgrOperatorService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrCreateAgrOperatorRspBo createAgrOperator(AgrCreateAgrOperatorReqBo reqBo) {
        if (null == reqBo.getAgrId()) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议id]不能为空");
        }
        //清空协议下所有经办人
        AgrAgrDo deleteAgrAgrDo = new AgrAgrDo();
        deleteAgrAgrDo.setAgrId(reqBo.getAgrId());
        deleteAgrAgrDo.setFieldCodeList(Arrays.asList("agrOperatorId", "agrOperatorName", "agrOperatorUserName"));
        this.iAgrAgrModel.deleteAgrMainExt(deleteAgrAgrDo);
        //新增经办人信息
        AgrAgrDo createAgrAgrDo = new AgrAgrDo();
        createAgrAgrDo.setAgrId(reqBo.getAgrId());
        List<AgrMainExt> agrMainExt = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(reqBo.getAgrCreateAgrOperatorBos())) {
            int userNo = 1;
            for (AgrCreateAgrOperatorBo agrCreateAgrOperatorBo : reqBo.getAgrCreateAgrOperatorBos()) {
                //一个用户存在三条数据保证备注一样
                AgrMainExt agrMainExtBo1 = new AgrMainExt();
                agrMainExtBo1.setFieldCode("agrOperatorId");
                agrMainExtBo1.setFieldName("经办人id");
                agrMainExtBo1.setFieldValue(agrCreateAgrOperatorBo.getAgrOperatorId().toString());
                agrMainExtBo1.setRemark(String.valueOf(userNo));
                agrMainExt.add(agrMainExtBo1);
                AgrMainExt agrMainExtBo2 = new AgrMainExt();
                agrMainExtBo2.setFieldCode("agrOperatorName");
                agrMainExtBo2.setFieldName("经办人真实姓名");
                agrMainExtBo2.setFieldValue(agrCreateAgrOperatorBo.getAgrOperatorName());
                agrMainExtBo2.setRemark(String.valueOf(userNo));
                agrMainExt.add(agrMainExtBo2);
                AgrMainExt agrMainExtBo3 = new AgrMainExt();
                agrMainExtBo3.setFieldCode("agrOperatorUserName");
                agrMainExtBo3.setFieldName("经办人账号");
                agrMainExtBo3.setFieldValue(agrCreateAgrOperatorBo.getAgrOperatorUserName());
                agrMainExtBo3.setRemark(String.valueOf(userNo));
                agrMainExt.add(agrMainExtBo3);
                userNo++;
            }
        }
        createAgrAgrDo.setAgrMainExtBOs(agrMainExt);
        this.iAgrAgrModel.createAgrMainExt(createAgrAgrDo);
        return AgrRu.success(AgrCreateAgrOperatorRspBo.class);
    }
}
