package com.tydic.dyc.agr.service.agr;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.bo.AgrDealAgrItemPurNumBo;
import com.tydic.dyc.agr.service.agr.bo.AgrDealAgrItemPurNumReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrDealAgrItemPurNumRspBo;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：AgrDealAgrItemPurNumServiceImpl
 * 说明：协议明细采购数量扣减/回退服务实现
 * 时间：2024/7/17 16:16
 *
 * @author 周钰焱
 */
@HTServiceImpl
public class AgrDealAgrItemPurNumServiceImpl implements AgrDealAgrItemPurNumService {

    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    private static final Integer PUR_NUM_OPER_TYPE_DEDUCT = 1;
    private static final Integer PUR_NUM_OPER_TYPE_RETURN = 2;

    @Override
    public AgrDealAgrItemPurNumRspBo dealAgrItemPurNum(AgrDealAgrItemPurNumReqBo reqBo) {
        AgrDealAgrItemPurNumRspBo rspBo = new AgrDealAgrItemPurNumRspBo();
        //校验入参
        virifyReq(reqBo);
        //组装入参
        List<Long> agrIds = reqBo.getAgrDealAgrItemPurNumBoList().stream().map(AgrDealAgrItemPurNumBo::getAgrId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> agrItemIds = reqBo.getAgrDealAgrItemPurNumBoList().stream().map(AgrDealAgrItemPurNumBo::getAgrItemId).distinct().filter(Objects::nonNull).collect(Collectors.toList());

        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrIds(agrIds);
        agrAgrQryBo.setPageNo(-1);
        agrAgrQryBo.setPageSize(-1);
        AgrGetAgrMainListRspQryBo agrMainList = this.iAgrAgrModel.getAgrMainList(agrAgrQryBo);
        if (agrIds.size() != agrMainList.getRows().size()) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议明细采购数量操作信息集合]协议ID集合与协议主表集合不一致");
        }

        AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
        agrItemListQryReqPageBo.setAgrItemIds(agrItemIds);
        agrItemListQryReqPageBo.setPageNo(-1);
        agrItemListQryReqPageBo.setPageSize(-1);
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.qryAgrItemList(agrItemListQryReqPageBo);
        if (agrItemIds.size() != agrItemListQryRspPageBo.getRows().size()) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议明细采购数量操作信息集合]协议明细ID集合与协议明细列表集合不一致");
        }
        AgrAgrDo agrDo = new AgrAgrDo();
        List<AgrItem> agrItemList = new ArrayList<>(reqBo.getAgrDealAgrItemPurNumBoList().size());
        Map<Long, AgrItem> agrItemMap = agrItemListQryRspPageBo.getRows().stream().collect(Collectors.toMap(AgrItem::getAgrItemId, agrItem -> agrItem, (k1, k2) -> k1));
        //如果该次操作为扣减，则校验协议明细采购数量是否足够

        //存在同一批次明细id相同，数量不同的多条数据，需要先按照明细id将这些数据合并数量
        Map<Long, List<AgrDealAgrItemPurNumBo>> reqAgrItemIdMap = reqBo.getAgrDealAgrItemPurNumBoList().stream().collect(Collectors.groupingBy(AgrDealAgrItemPurNumBo::getAgrItemId));
        List<Long> duplicateIds = reqAgrItemIdMap.entrySet().stream()
                .filter(entry -> entry.getValue().size() > 1)
                .map(Map.Entry::getKey)
                .collect(Collectors.toList());
        if (!duplicateIds.isEmpty()) {
            //有重复的明细id，明细数据进行合并
            Map<Long, AgrDealAgrItemPurNumBo> idBoMap = new HashMap<>();

            for (AgrDealAgrItemPurNumBo bo : reqBo.getAgrDealAgrItemPurNumBoList()) {
                idBoMap.compute(bo.getAgrItemId(), (id, existingBo) -> {
                    if (existingBo == null) {
                        return bo; // 如果没有重复的 id，直接返回当前 Bo
                    } else {
                        // 如果有重复的 id，将 数量 相加，并保留其他字段
                        existingBo.setOperNum(existingBo.getOperNum().add(bo.getOperNum()));
                        return existingBo;
                    }
                });
            }

            List<AgrDealAgrItemPurNumBo> newAgrItemList = new ArrayList<>(idBoMap.values());
            if (PUR_NUM_OPER_TYPE_DEDUCT.equals(reqBo.getOperType())) {
                newAgrItemList.forEach(agrDealAgrItemPurNumBo -> {
                    AgrItem agrItemUpdate = new AgrItem();
                    AgrItem agrItem = agrItemMap.get(agrDealAgrItemPurNumBo.getAgrItemId());
                    if (agrItem.getIsControlPurchaseNum() == 1 && agrDealAgrItemPurNumBo.getOperNum().compareTo(agrItem.getLeftNumber()) > 0) {
                        throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议明细采购数量操作信息集合]协议明细采购数量不能大于协议明细剩余可执行数量");
                    }
                    agrItemUpdate.setAgrItemId(agrDealAgrItemPurNumBo.getAgrItemId());
                    agrItemUpdate.setExecutedNumber(agrItem.getExecutedNumber().add(agrDealAgrItemPurNumBo.getOperNum()));
                    //不控制采购数量可以一直扣减到0为止
                    agrItemUpdate.setLeftNumber(
                            (agrItem.getLeftNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()).compareTo(BigDecimal.ZERO) < 0)
                                    ? BigDecimal.ZERO : agrItem.getLeftNumber().subtract(agrDealAgrItemPurNumBo.getOperNum())
                    );
                    agrItemList.add(agrItemUpdate);
                });
            }
            if (PUR_NUM_OPER_TYPE_RETURN.equals(reqBo.getOperType())) {
                newAgrItemList.forEach(agrDealAgrItemPurNumBo -> {
                    AgrItem agrItemUpdate = new AgrItem();
                    AgrItem agrItem = agrItemMap.get(agrDealAgrItemPurNumBo.getAgrItemId());
                    agrItemUpdate.setAgrItemId(agrDealAgrItemPurNumBo.getAgrItemId());
//                if ((agrItem.getExecutedNumber().add(agrDealAgrItemPurNumBo.getOperNum())).compareTo(agrItem.getBuyNumber()) > 0) {
//                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议明细采购数量操作信息集合]回退后的可执行数量大于采购数量了");
//                }
                    agrItemUpdate.setExecutedNumber(agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()));
                    //已执行数量减退还的数量大于等于采购数量，则回退后的剩余数量等于0
                    if (agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()).compareTo(agrItem.getBuyNumber()) >= 0) {
                        agrItemUpdate.setLeftNumber(BigDecimal.ZERO);
                    }
                    //已执行数量减退还的数量小于采购数量，则回退后的剩余数量等于采购数量减去已执行数量+
                    else {
                        agrItemUpdate.setLeftNumber(agrItem.getBuyNumber().subtract(agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum())));
                    }
//                agrItemUpdate.setLeftNumber(agrItem.getLeftNumber().add(agrDealAgrItemPurNumBo.getOperNum()).compareTo(agrItem.getBuyNumber()) > 0 ? agrItem.getBuyNumber() : agrItem.getLeftNumber().add(agrDealAgrItemPurNumBo.getOperNum()));
                    agrItemList.add(agrItemUpdate);
                });
            }
            agrDo.setAgrItem(agrItemList);
            this.iAgrAgrModel.updateAgrItemByBatch(agrDo);

        }else {
            if (PUR_NUM_OPER_TYPE_DEDUCT.equals(reqBo.getOperType())) {
                reqBo.getAgrDealAgrItemPurNumBoList().forEach(agrDealAgrItemPurNumBo -> {
                    AgrItem agrItemUpdate = new AgrItem();
                    AgrItem agrItem = agrItemMap.get(agrDealAgrItemPurNumBo.getAgrItemId());
                    if (agrItem.getIsControlPurchaseNum() == 1 && agrDealAgrItemPurNumBo.getOperNum().compareTo(agrItem.getLeftNumber()) > 0) {
                        throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议明细采购数量操作信息集合]协议明细采购数量不能大于协议明细剩余可执行数量");
                    }
                    agrItemUpdate.setAgrItemId(agrDealAgrItemPurNumBo.getAgrItemId());
                    agrItemUpdate.setExecutedNumber(agrItem.getExecutedNumber().add(agrDealAgrItemPurNumBo.getOperNum()));
                    //不控制采购数量可以一直扣减到0为止
                    agrItemUpdate.setLeftNumber(
                            (agrItem.getLeftNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()).compareTo(BigDecimal.ZERO) < 0)
                                    ? BigDecimal.ZERO : agrItem.getLeftNumber().subtract(agrDealAgrItemPurNumBo.getOperNum())
                    );
                    agrItemList.add(agrItemUpdate);
                });
            }
            if (PUR_NUM_OPER_TYPE_RETURN.equals(reqBo.getOperType())) {
                reqBo.getAgrDealAgrItemPurNumBoList().forEach(agrDealAgrItemPurNumBo -> {
                    AgrItem agrItemUpdate = new AgrItem();
                    AgrItem agrItem = agrItemMap.get(agrDealAgrItemPurNumBo.getAgrItemId());
                    agrItemUpdate.setAgrItemId(agrDealAgrItemPurNumBo.getAgrItemId());
//                if ((agrItem.getExecutedNumber().add(agrDealAgrItemPurNumBo.getOperNum())).compareTo(agrItem.getBuyNumber()) > 0) {
//                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议明细采购数量操作信息集合]回退后的可执行数量大于采购数量了");
//                }
                    agrItemUpdate.setExecutedNumber(agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()));
                    //已执行数量减退还的数量大于等于采购数量，则回退后的剩余数量等于0
                    if (agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()).compareTo(agrItem.getBuyNumber()) >= 0) {
                        agrItemUpdate.setLeftNumber(BigDecimal.ZERO);
                    }
                    //已执行数量减退还的数量小于采购数量，则回退后的剩余数量等于采购数量减去已执行数量+
                    else {
                        agrItemUpdate.setLeftNumber(agrItem.getBuyNumber().subtract(agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum())));
                    }
//                agrItemUpdate.setLeftNumber(agrItem.getLeftNumber().add(agrDealAgrItemPurNumBo.getOperNum()).compareTo(agrItem.getBuyNumber()) > 0 ? agrItem.getBuyNumber() : agrItem.getLeftNumber().add(agrDealAgrItemPurNumBo.getOperNum()));
                    agrItemList.add(agrItemUpdate);
                });
            }
            agrDo.setAgrItem(agrItemList);
            this.iAgrAgrModel.updateAgrItemByBatch(agrDo);
        }


        return rspBo;
    }

    private void virifyReq(AgrDealAgrItemPurNumReqBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参不能为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getAgrDealAgrItemPurNumBoList())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议明细采购数量操作信息集合]不能为空");
        }
        if (null == reqBO.getOperType()) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[操作类型]不能为空");
        }
        if (!PUR_NUM_OPER_TYPE_DEDUCT.equals(reqBO.getOperType()) && !PUR_NUM_OPER_TYPE_RETURN.equals(reqBO.getOperType())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[操作类型]错误");
        }
    }
}
