package com.tydic.dyc.agr.service.agr;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.components.es.AgrElasticsearchUtil;
import com.tydic.dyc.agr.config.AgrIndexConfig;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyListRspBO;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrChngApply;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrTaskQryBo;
import com.tydic.dyc.agr.service.agr.bo.*;
import com.tydic.dyc.agr.service.agrchange.AgrGetAgrChngApplyDetailService;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:AgrEsSyncServiceImpl
 * 说明:
 * 时间:2022/8/29 15:05
 * 作者:田桂银
 */
@HTServiceImpl
@Slf4j
public class AgrEsSyncServiceImpl implements AgrEsSyncService {
    @Autowired
    private AgrIndexConfig agrIndexConfig;
    @Autowired
    private AgrElasticsearchUtil agrElasticsearchUtil;
    @Autowired
    private IAgrAgrModel agrAgrModel;
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;
    @Autowired
    private AgrGetAgrDetailService agrGetAgrDetailService;
    @Autowired
    private AgrGetAgrChngApplyDetailService agrGetAgrChngApplyDetailService;
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Override
    public AgrEsSyncServiceRspBo sync(AgrEsSyncServiceReqBo reqBo) {
        if (!reqBo.getAll()) {
            if(reqBo.getSyncType().equals("1")){
                this.syncAgrSingle(reqBo.getAgrId());
            }else {
                this.syncAgrChngSingle(reqBo.getAgrId(),reqBo.getChngApplyId());
            }
        }else {
            // 删除索引
            delIdx(agrIndexConfig.getAgrIndex());
            this.syncAgrAll();
            this.syncAgrChngAll();
        }
        return AgrRu.success(AgrEsSyncServiceRspBo.class);
    }
    /**
     * 单条协议同步
     */
    private void syncAgrSingle(Long agrId){
        // 查询协议详情
        AgrGetAgrDetailReqBo agrGetAgrDetailReqBo = new AgrGetAgrDetailReqBo();
        agrGetAgrDetailReqBo.setAgrId(agrId);
        AgrGetAgrDetailRspBo agrGetAgrDetailRspBo = this.agrGetAgrDetailService.getAgrDetail(agrGetAgrDetailReqBo);
        if(agrGetAgrDetailRspBo!=null && agrGetAgrDetailRspBo.getAgrMainSaveBO()!=null){
            AgrAgrEsBo agrAgrEsBo = AgrRu.js(agrGetAgrDetailRspBo.getAgrMainSaveBO(), AgrAgrEsBo.class);
            agrAgrEsBo.setDataType(1);
            // 处理审批流数据
            agrAgrEsBo.setAuditProclnstld(agrGetAgrDetailRspBo.getProcInstId());
            if(!StringUtils.isBlank(agrAgrEsBo.getAuditProclnstld())){
                AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
                agrTaskQryBo.setProcInstId(agrAgrEsBo.getAuditProclnstld());
                agrTaskQryBo.setOrderId(agrAgrEsBo.getAgrId());
                AgrProcInstDo agrProcInstDo = this.iAgrProcInstModel.getTaskList(agrTaskQryBo);
                List<AgrTastEsBo> agrTastEsBos = new ArrayList<>();
                agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst->{
                    AgrTastEsBo agrTastEsBo = AgrRu.js(uocOrderTaskInst, AgrTastEsBo.class);
                    agrTastEsBo.setAuditDealResultQryKey(uocOrderTaskInst.getRemark());
                    agrTastEsBos.add(agrTastEsBo);
                });
                agrAgrEsBo.setAuditTaskList(agrTastEsBos);
            }
            // 处理业务流数据
            agrAgrEsBo.setBusiProclnstld(qryBusiProInstId(AgrCommConstant.ObjType.AGREEMENT,agrAgrEsBo.getAgrId(),agrAgrEsBo.getAgrId()));
            if(!StringUtils.isBlank(agrAgrEsBo.getBusiProclnstld())){
                AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
                agrTaskQryBo.setProcInstId(agrAgrEsBo.getBusiProclnstld());
                agrTaskQryBo.setOrderId(agrAgrEsBo.getAgrId());
                AgrProcInstDo agrProcInstDo = this.iAgrProcInstModel.getTaskList(agrTaskQryBo);
                List<AgrTastEsBo> agrTastEsBos = new ArrayList<>();
                agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst->{
                    AgrTastEsBo agrTastEsBo = AgrRu.js(uocOrderTaskInst, AgrTastEsBo.class);
                    agrTastEsBo.setAuditDealResultQryKey(uocOrderTaskInst.getRemark());
                    agrTastEsBos.add(agrTastEsBo);
                });
                agrAgrEsBo.setBusiTaskList(agrTastEsBos);

            }
            // 处理明细数量
            if(AgrCommConstant.WhetherHaveItemEnum.WHETHER_HAVE_ITEM_YES.getValue().equals(agrAgrEsBo.getWhetherHaveItem())){
                AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
                agrItemListQryReqPageBo.setAgrId(agrId);
                agrItemListQryReqPageBo.setPageNo(1);
                agrItemListQryReqPageBo.setPageSize(1);
                AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.agrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
                if(agrItemListQryRspPageBo!=null && agrItemListQryRspPageBo.getRows()!=null){
                    agrAgrEsBo.setAgrItemCount(agrItemListQryRspPageBo.getRecordsTotal());
                }else {
                    agrAgrEsBo.setAgrItemCount(0);
                }
                   
            }
            // 处理应用范围
            if(!CollectionUtils.isEmpty(agrGetAgrDetailRspBo.getAgrAppScopeBOs())){
                List<AgrScopeEsBo> scopeIds = new ArrayList<>();
                agrGetAgrDetailRspBo.getAgrAppScopeBOs().forEach(agrAppScopeBo -> {
                    AgrScopeEsBo bo = JUtil.js(agrAppScopeBo, AgrScopeEsBo.class);
                    bo.setScopeId(agrAppScopeBo.getScopeCode());
                    scopeIds.add(bo);
                });
                agrAgrEsBo.setScopeIds(scopeIds);
            }
            // 处理是否有在途变更申请
            AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new AgrAgrChngApplyQryBo() ;
            agrAgrChngApplyQryBo.setAgrId(agrAgrEsBo.getAgrId());
            agrAgrChngApplyQryBo.setOrderBy("create_time desc LIMIT 1");
            AgrAgrChngApplyListRspBO rspBO = this.iAgrChngApplyModel.getAgrChngApplyList(agrAgrChngApplyQryBo);
            if(rspBO!=null && !CollectionUtils.isEmpty(rspBO.getAgrChngApply())){
                AgrChngApply agrChngApply = rspBO.getAgrChngApply().get(0);
                AgrTaskQryBo agrTaskQryBo = new  AgrTaskQryBo();
                agrTaskQryBo.setOrderId(agrAgrEsBo.getAgrId());
                agrTaskQryBo.setObjId(agrChngApply.getChngApplyId());
                agrTaskQryBo.setObjType(AgrCommConstant.ObjType.CHANGE);
                agrTaskQryBo.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
                AgrProcInstDo agrProcInstDo = iAgrProcInstModel.getTaskList(agrTaskQryBo);
                if(!CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskInst())) {
                    // 还有在途变更申请，最新版本没有生效
                    agrAgrEsBo.setHaveProcessingChng(1);
                    agrAgrEsBo.setHaveProcessingChngStr("否");
                }else {
                    // 没有在途变更申请，最新版本已生效
                    agrAgrEsBo.setHaveProcessingChng(2);
                    agrAgrEsBo.setHaveProcessingChngStr("是");
                }
            }else {
                // 没有在途变更申请，最新版本已生效
                agrAgrEsBo.setHaveProcessingChng(2);
                agrAgrEsBo.setHaveProcessingChngStr("是");
            }
            agrElasticsearchUtil.addJsonData(agrIndexConfig.getAgrIndex(), agrId.toString(), JSON.toJSONString(agrAgrEsBo));
        }

    }
    /**
     * 查询业务流程实例ID
     */
    private String qryBusiProInstId(Integer objType, Long orderId, Long objId) {
        String procInstId = "";
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        agrProcInstDo.setOrderId(orderId);
        agrProcInstDo.setObjId(objId);
        agrProcInstDo.setObjType(objType);
        agrProcInstDo.setOrderBy("id desc LIMIT 1");
        AgrProcInstDo agrProcInstDo1 = iAgrProcInstModel.getProcInst(agrProcInstDo);
        if (agrProcInstDo1 != null) {
            procInstId = agrProcInstDo1.getProcInstId();
        }
        return procInstId;
    }
    /**
     * 全量协议同步
     */
    private void syncAgrAll(){
        AgrListQryReqPageBo agrListQryReqPageBo = new AgrListQryReqPageBo();
        agrListQryReqPageBo.setPageNo(1);
        agrListQryReqPageBo.setPageSize(1000);
        AgrListQryRspPageBo agrListQryRspPageBo = this.agrAgrModel.getAllAgrList(agrListQryReqPageBo);
        if(!CollectionUtils.isEmpty(agrListQryRspPageBo.getRows())){
            int total = agrListQryRspPageBo.getTotal();
            for (int i=1;i<=total;i++){
                agrListQryReqPageBo.setPageNo(i);
                agrListQryReqPageBo.setPageSize(1000);
                AgrListQryRspPageBo agrListQryRspPageBo1 = this.agrAgrModel.getAllAgrList(agrListQryReqPageBo);
                agrListQryRspPageBo1.getRows().forEach(agrAgrDo -> {
                    this.syncAgrSingle(agrAgrDo.getAgrId());
                });
            }
        }

    }
    /**
     * 单条变更申请协议同步
     */
    private void syncAgrChngSingle(Long agrId,Long chngApplyId){
        // 查询协议详情
        AgrGetAgrDetailReqBo agrGetAgrDetailReqBo = new AgrGetAgrDetailReqBo();
        agrGetAgrDetailReqBo.setAgrId(agrId);
        AgrGetAgrDetailRspBo agrGetAgrDetailRspBo = this.agrGetAgrDetailService.getAgrDetail(agrGetAgrDetailReqBo);
        if(agrGetAgrDetailRspBo!=null && agrGetAgrDetailRspBo.getAgrMainSaveBO()!=null){
            // 查询变更申请详情
            AgrGetAgrChngApplyDetailReqBO applyDetailReqBO = new AgrGetAgrChngApplyDetailReqBO();
            applyDetailReqBO.setAgrId(agrId);
            applyDetailReqBO.setChngApplyId(chngApplyId);
            AgrGetAgrChngApplyDetailRspBO agrChngApplyDetail = this.agrGetAgrChngApplyDetailService.getAgrChngApplyDetail(applyDetailReqBO);
            if(agrChngApplyDetail!=null){
                AgrAgrChngEsBo agrAgrChngEsBo = AgrRu.js(agrGetAgrDetailRspBo.getAgrMainSaveBO(), AgrAgrChngEsBo.class);
                // 处理应用范围
                if(!CollectionUtils.isEmpty(agrGetAgrDetailRspBo.getAgrAppScopeBOs())){
                    List<AgrScopeEsBo> scopeIds = new ArrayList<>();
                    agrGetAgrDetailRspBo.getAgrAppScopeBOs().forEach(agrAppScopeBo -> {
                        AgrScopeEsBo bo = JUtil.js(agrAppScopeBo, AgrScopeEsBo.class);
                        bo.setScopeId(agrAppScopeBo.getScopeCode());
                        scopeIds.add(bo);
                    });
                    agrAgrChngEsBo.setScopeIds(scopeIds);
                }
                agrAgrChngEsBo.setChngApplyId(agrChngApplyDetail.getChngApplyId());
                agrAgrChngEsBo.setChngApplyNo(agrChngApplyDetail.getChngApplyNo());
                agrAgrChngEsBo.setChngApplyStatus(agrChngApplyDetail.getChngApplyStatus());
                agrAgrChngEsBo.setChngType(agrChngApplyDetail.getChngType());
                agrAgrChngEsBo.setApplyCreateTime(agrChngApplyDetail.getCreateTime());
                agrAgrChngEsBo.setApplyCreateName(agrChngApplyDetail.getCreateName());
                agrAgrChngEsBo.setChngTypeStr(agrChngApplyDetail.getChngTypeStr());
                agrAgrChngEsBo.setChngApplyStatusStr(agrChngApplyDetail.getChngApplyStatusStr());
                agrAgrChngEsBo.setDataType(2);
                // 处理审批流数据
                agrAgrChngEsBo.setAuditProclnstld(agrChngApplyDetail.getProcInstId());
                if(!StringUtils.isBlank(agrAgrChngEsBo.getAuditProclnstld())){
                    AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
                    agrTaskQryBo.setProcInstId(agrAgrChngEsBo.getAuditProclnstld());
                    agrTaskQryBo.setOrderId(agrAgrChngEsBo.getAgrId());
                    AgrProcInstDo agrProcInstDo = this.iAgrProcInstModel.getTaskList(agrTaskQryBo);
                    List<AgrTastEsBo> agrTastEsBos = new ArrayList<>();
                    agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst->{
                        AgrTastEsBo agrTastEsBo = AgrRu.js(uocOrderTaskInst, AgrTastEsBo.class);
                        agrTastEsBo.setAuditDealResultQryKey(uocOrderTaskInst.getRemark());
                        agrTastEsBos.add(agrTastEsBo);
                    });
                    agrAgrChngEsBo.setAuditTaskList(agrTastEsBos);
                }
                // 处理业务流数据
                agrAgrChngEsBo.setBusiProclnstld(qryBusiProInstId(AgrCommConstant.ObjType.CHANGE,agrAgrChngEsBo.getAgrId(),agrAgrChngEsBo.getChngApplyId()));
                if(!StringUtils.isBlank(agrAgrChngEsBo.getBusiProclnstld())){
                    AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
                    agrTaskQryBo.setProcInstId(agrAgrChngEsBo.getBusiProclnstld());
                    agrTaskQryBo.setOrderId(agrAgrChngEsBo.getAgrId());
                    AgrProcInstDo agrProcInstDo = this.iAgrProcInstModel.getTaskList(agrTaskQryBo);
                    List<AgrTastEsBo> agrTastEsBos = new ArrayList<>();
                    agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst->{
                        AgrTastEsBo agrTastEsBo = AgrRu.js(uocOrderTaskInst, AgrTastEsBo.class);
                        agrTastEsBo.setAuditDealResultQryKey(uocOrderTaskInst.getRemark());
                        agrTastEsBos.add(agrTastEsBo);
                    });
                    agrAgrChngEsBo.setBusiTaskList(agrTastEsBos);
                }
                agrElasticsearchUtil.addJsonData(agrIndexConfig.getAgrIndex(), chngApplyId.toString(), JSON.toJSONString(agrAgrChngEsBo));
            }
        }

    }
    /**
     * 全量协议变更申请同步
     */
    private void syncAgrChngAll(){
        AgrAgrChngApplyListQryReqPageBo agrAgrChngApplyListQryReqPageBo = new AgrAgrChngApplyListQryReqPageBo();
        agrAgrChngApplyListQryReqPageBo.setPageNo(1);
        agrAgrChngApplyListQryReqPageBo.setPageSize(1000);
        AgrAgrChngApplyListQryRspPageBo agrAgrChngApplyListQryRspPageBo = this.iAgrChngApplyModel.getAllChngByPage(agrAgrChngApplyListQryReqPageBo);
        if(!CollectionUtils.isEmpty(agrAgrChngApplyListQryRspPageBo.getRows())){
            int total = agrAgrChngApplyListQryRspPageBo.getTotal();
            for (int i=1;i<=total;i++){
                agrAgrChngApplyListQryReqPageBo.setPageNo(i);
                agrAgrChngApplyListQryReqPageBo.setPageSize(1000);
                AgrAgrChngApplyListQryRspPageBo agrAgrChngApplyListQryRspPageBo1 = this.iAgrChngApplyModel.getAllChngByPage(agrAgrChngApplyListQryReqPageBo);
                agrAgrChngApplyListQryRspPageBo1.getRows().forEach(agrChngApply -> {
                    this.syncAgrChngSingle(agrChngApply.getAgrId(),agrChngApply.getChngApplyId());
                });
            }
        }
    }
    /**
     * 删除索引
     */
    private void delIdx(String idx) {
        try {
            agrElasticsearchUtil.deleteIndex(idx);
        } catch (Exception e) {
            String eCause = JSON.toJSONString(e.getCause());
            log.error(eCause);
            if (eCause.contains(AgrIndexConfig.INDEX_EXCEPTION)) {
                log.info("索引不存在");
            }
        }
    }

}


