package com.tydic.dyc.agr.service.agr;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrDetailReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrMainExtBo;
import com.tydic.dyc.agr.service.agr.bo.AgrMainExtListRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：AgrGetAgrExtListImpl
 * 说明：
 * 时间： 2024-08-13 19:11
 * 作者 @author LY
 */
@HTServiceImpl
public class AgrGetAgrExtListImpl implements AgrGetAgrExtList {

    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrMainExtListRspBO getAgrExtList(AgrGetAgrDetailReqBo reqBO) {
        AgrMainExtListRspBO rspBO = new AgrMainExtListRspBO();
        rspBO.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(AgrRspConstant.RESP_DESC_SUCCESS);
        AgrAgrQryBo agrAgrQryBo = JSON.parseObject(JSON.toJSONString(reqBO), AgrAgrQryBo.class);
        AgrAgrDo agrExtList = iAgrAgrModel.getAgrExtList(agrAgrQryBo);
        rspBO.setRows(JSON.parseArray(JSON.toJSONString(agrExtList.getAgrMainExtBOs()), AgrMainExtBo.class));
        return rspBO;
    }
}
