package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.bo.AgrItemBo;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListByOrgIdReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListByOrgIdRspBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：AgrGetAgrItemListByOrgIdServiceImpl
 * 说明：查询采购单位适用协议明细列表实现
 * 时间：2024/7/24 14:59
 *
 * @author 周钰焱
 */
@HTServiceImpl
public class AgrGetAgrItemListByOrgIdServiceImpl implements AgrGetAgrItemListByOrgIdService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;

    @Override
    public AgrGetAgrItemListByOrgIdRspBo getAgrItemListByOrgId(AgrGetAgrItemListByOrgIdReqBo reqBo) {
        AgrGetAgrItemListByOrgIdRspBo rspBo = new AgrGetAgrItemListByOrgIdRspBo();
        rspBo.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(AgrRspConstant.RESP_DESC_SUCCESS);
        virifyReq(reqBo);
        List<String> scopeCodes = new ArrayList<>();
        if (!ObjectUtil.isEmpty(reqBo.getPurOrgPath())) {
            scopeCodes = Arrays.asList(reqBo.getPurOrgPath().split("-"));
        }
        //查询采购单位适用的所有协议
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
//        agrAgrQryBo.setScopeCode(reqBo.getPurOrgId().toString());
        agrAgrQryBo.setScopeCodes(scopeCodes);
        agrAgrQryBo.setAgrType(AgrCommConstant.AgrType.AGR);
        List<AgrAppScope> otherAgrAppScopes = iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo);

        //查询是全平台的应用范围
        AgrAgrQryBo agrAgrQryBo1 = new AgrAgrQryBo();
        agrAgrQryBo1.setScopeType(AgrCommConstant.ScopeType.ALL);
        List<AgrAppScope> agrAppScopes = iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo1);
        if (!CollectionUtils.isEmpty(agrAppScopes)) {
            otherAgrAppScopes.addAll(agrAppScopes);
        }
        if (CollectionUtils.isEmpty(otherAgrAppScopes)) {
            return rspBo;
        }


        List<String> pCodeList = new ArrayList<>();
        pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_SRC_PCODE);
        pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_CONTROL_PCODE);
        pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_PRICE_ADJUST_PCODE);
        pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_STATUS_PCODE);
        // 查询字典
        Map<String, Map<String, DicDictionaryBo>> dicMap = this.iAgrDictionaryModel.selectByPCodeListToMap(pCodeList);

        //协议主体信息map
        AgrAgrQryBo agrQryBo = new AgrAgrQryBo();
        agrQryBo.setAgrIds(otherAgrAppScopes.stream().map(AgrAppScope::getAgrId).distinct().collect(Collectors.toList()));
        agrQryBo.setPageNo(-1);
        agrQryBo.setPageSize(-1);
        agrQryBo.setAgrStatus(AgrCommConstant.AgreementStatus.ENABLE);
        agrQryBo.setAgrType(AgrCommConstant.AgrType.AGR);
        //只查询维护了是否商城铺货的协议
        agrQryBo.setWhetherStorePlanFlag(AgrCommConstant.WhetherStorePlanEnum.WHETHER_STORE_PLAN_YES.getValue());
        AgrGetAgrMainListRspQryBo agrMainList = iAgrAgrModel.getAgrMainList(agrQryBo);
        Map<Long, AgrAgrDo> agrMap = agrMainList.getRows().stream().collect(Collectors.toMap(AgrAgrDo::getAgrId, agrAgrDo -> agrAgrDo, (k1, k2) -> k1));
        //通过协议id集合和物料编码集合跨协议查询协议明细
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
        if (!CollectionUtils.isEmpty(reqBo.getAgrItemIds())) {
            //按协议明细id查询（不区分状态）
            agrItemListQryReqPageBo.setAgrItemIds(reqBo.getAgrItemIds());
        } else {
            agrItemListQryReqPageBo.setAgrItemIds(otherAgrAppScopes.stream().map(AgrAppScope::getAgrItemId).distinct().collect(Collectors.toList()));
            agrItemListQryReqPageBo.setAgrItemStatus(1);
        }
        agrItemListQryReqPageBo.setMaterialCodeList(reqBo.getMaterialCodeList());
        agrItemListQryReqPageBo.setPageNo(reqBo.getPageNo());
        agrItemListQryReqPageBo.setPageSize(reqBo.getPageSize());
        AgrItemListQryRspPageBo agrItemList = iAgrAgrModel.qryAgrItemList(agrItemListQryReqPageBo);
        rspBo = JSONObject.parseObject(JSONObject.toJSONString(agrItemList), AgrGetAgrItemListByOrgIdRspBo.class);
        rspBo.setRows(rspBo.getRows().stream().filter(row -> agrMap.containsKey(row.getAgrId())).collect(Collectors.toList()));
        for (AgrItemBo row : rspBo.getRows()) {
            if (agrMap.containsKey(row.getAgrId())) {
                AgrAgrDo agrAgrDo = agrMap.get(row.getAgrId());
                //协议主体的信息维护到明细上
                row.setSupplierId(agrAgrDo.getSupplierId());
                row.setSupplierName(agrAgrDo.getSupplierName());
                row.setAgrCode(agrAgrDo.getAgrCode());
                row.setRelCode(agrAgrDo.getRelCode());
                row.setAgrSrc(agrAgrDo.getAgrSrc());
                row.setExecutionMethod(agrAgrDo.getExecutionMethod());
                row.setEffDate(agrAgrDo.getEffDate());
                row.setExpDate(agrAgrDo.getExpDate());
                row.setAgrStatus(agrAgrDo.getAgrStatus());
            }
        }
        translation(rspBo, dicMap, agrMap);
        return rspBo;
    }

    /**
     * 翻译
     *
     * @param rspBO 入参
     */
    private void translation(AgrGetAgrItemListByOrgIdRspBo rspBO, Map<String, Map<String, DicDictionaryBo>> dicMap, Map<Long, AgrAgrDo> agrMap) {
        if (rspBO != null) {
            List<AgrItemBo> rows = rspBO.getRows();
            if (!CollectionUtils.isEmpty(rows)) {
                rows.forEach(x -> {
                            if (agrMap.containsKey(x.getAgrId())) {
                                x.setAgrCode(agrMap.get(x.getAgrId()).getAgrCode());
                            }
                            if (x.getAgrSrc() != null) {
                                x.setAgrSrcStr(
                                        MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_SRC_PCODE)) ? null :
                                                dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_SRC_PCODE).get(x.getAgrSrc().toString()).getTitle());
                            }
                            if (x.getIsControlPurchaseNum() != null) {
                                x.setIsControlPurchaseNumStr(
                                        MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_CONTROL_PCODE)) ? null :
                                                dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_CONTROL_PCODE).get(x.getIsControlPurchaseNum().toString()).getTitle());
                            }
                            if (x.getIsPriceAdjust() != null) {
                                x.setIsPriceAdjustStr(
                                        MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_PRICE_ADJUST_PCODE)) ? null :
                                                dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_IS_PRICE_ADJUST_PCODE).get(x.getIsPriceAdjust().toString()).getTitle());
                            }
                            if (x.getAgrItemStatus() != null) {
                                x.setAgrItemStatusStr(
                                        MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_STATUS_PCODE)) ? null :
                                                dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_STATUS_PCODE).get(x.getAgrItemStatus().toString()).getTitle());
                            }
                        }
                );
            }
        }
    }

    /**
     * 入参校验
     *
     * @param reqBO
     */
    private void virifyReq(AgrGetAgrItemListByOrgIdReqBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
//        if (null == reqBO.getPurOrgId()) {
//            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[采购单位id]不能为空");
//        }
        if (ObjectUtil.isEmpty(reqBO.getPurOrgPath())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[采购单位机构树]不能为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getMaterialCodeList())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象集合[物料编码集合]不能为空");
        }
    }

    public static void main(String[] args) {

// 获取当前日期
        Date currentDate = new Date();

// 假设 reqBo.getExpDate() 返回一个 Date 对象
        String exp = "2024-07-24";
        Date expDate1 = DateUtil.parse(exp, "yyyy-MM-dd");
        Date expDate = new Date();
        System.out.println(currentDate);
        System.out.println(DateUtil.formatDate(expDate));
        System.out.println("=======到期时间不在当前时间之前" + !expDate1.before((DateUtil.parse(DateUtil.formatDate(currentDate), "yyyy-MM-dd"))));
        if (expDate.after(currentDate)) {
            System.out.println("Expiration date is in the future.");
        } else if (!expDate.before((DateUtil.parse(DateUtil.formatDate(currentDate), "yyyy-MM-dd")))) {
            System.out.println("111.");
        }

    }
}
