package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.*;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListCheckReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListCheckRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrItemNumBo;
import com.tydic.dyc.agr.service.agr.bo.AgrItemPriceExecutionBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：AgrGetAgrItemListCheckServiceImpl
 * 说明：协议明细列表查询校验服务实现
 * 时间：2024/7/10 14:19
 *
 * @author 周钰焱
 */
@Slf4j
@HTServiceImpl
public class AgrGetAgrItemListCheckServiceImpl implements AgrGetAgrItemListCheckService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrGetAgrItemListCheckRspBo getAgrItemListCheck(AgrGetAgrItemListCheckReqBo reqBO) {
        virifyReq(reqBO);

        //1 组装入参
        List<Long> agrItemIds = reqBO.getAgrItemNumInfoList().stream().map(AgrItemNumBo::getAgrItemId).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> extAgrItemIds = reqBO.getAgrItemNumInfoList().stream()
                .map(AgrItemNumBo::getExtAgrItemId)
                .filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> agrIds = new ArrayList<>(reqBO.getAgrItemNumInfoList().size());
        Map<Long, AgrAgrDo> agrMap = new HashMap<>(reqBO.getAgrItemNumInfoList().size());

        AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
        if (CollectionUtil.isNotEmpty(agrItemIds) && agrItemIds.size() > 0 && !agrItemIds.stream().allMatch(Objects::isNull)) {
            agrItemListQryReqPageBo.setAgrItemIds(agrItemIds);
        }
        if (CollectionUtil.isNotEmpty(extAgrItemIds) && extAgrItemIds.size() > 0 && !extAgrItemIds.stream().allMatch(s -> s == null || s.isEmpty())) {
            agrItemListQryReqPageBo.setExtAgrItemIds(extAgrItemIds);
        }
        agrItemListQryReqPageBo.setPageNo(-1);
        agrItemListQryReqPageBo.setPageSize(-1);
        //2 调用协议明细列表查询方法
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.qryAgrItemList(agrItemListQryReqPageBo);
        //3 组装出参
        if (!CollectionUtils.isEmpty(agrItemListQryRspPageBo.getRows())) {
            agrItemListQryRspPageBo.getRows().forEach(agrItemDetailBo -> reqBO.getAgrItemNumInfoList().forEach(agrItemNumBo -> {
                if (agrItemNumBo.getAgrItemId().equals(agrItemDetailBo.getAgrItemId()) ||
                        agrItemNumBo.getExtAgrItemId().equals(agrItemDetailBo.getExtAgrItemId())) {
                    if (agrItemNumBo.getPurNum().compareTo(agrItemDetailBo.getLeftNumber()) > 0) {
                        agrItemDetailBo.setIsExceed(1);
                    } else {
                        agrItemDetailBo.setIsExceed(0);
                    }
                }
            }));
            agrIds = agrItemListQryRspPageBo.getRows().stream().map(AgrItem::getAgrId).distinct().collect(Collectors.toList());
        }
        //查询协议主体信息
        if (CollectionUtil.isNotEmpty(agrIds)) {
            AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
            agrAgrQryBo.setAgrIds(agrIds);
            agrAgrQryBo.setPageNo(-1);
            agrAgrQryBo.setPageSize(-1);
            AgrGetAgrMainListRspQryBo agrMainList = iAgrAgrModel.getAgrMainList(agrAgrQryBo);
            agrMap = agrMainList.getRows().stream().collect(Collectors.toMap(AgrAgrDo::getAgrId, agrAgrDo -> agrAgrDo, (k1, k2) -> k1));
        }

        Map<Long, AgrAgrDo> finalAgrMap = agrMap;
        log.debug("finalAgrMap:{}", JSONObject.toJSONString(finalAgrMap));
        if (1 == reqBO.getReturnFlag()) {
            agrItemListQryRspPageBo.getRows().forEach(agrItemDetailBo -> {
                if (finalAgrMap.containsKey(agrItemDetailBo.getAgrId())) {
                    if (!finalAgrMap.get(agrItemDetailBo.getAgrId()).getAgrStatus().equals(AgrCommConstant.AgreementStatus.ENABLE)) {
                        throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "协议编号为[" + finalAgrMap.get(agrItemDetailBo.getAgrId()).getAgrCode() + "]的协议状态为终止");
                    }
                }
                if (agrItemDetailBo.getIsExceed() == 1 && 1 == agrItemDetailBo.getIsControlPurchaseNum()) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "协议明细ID为[" + agrItemDetailBo.getAgrItemId() + "]的协议明细采购数量不能大于协议明细剩余数量");
                }
                if (agrItemDetailBo.getAgrItemStatus() == 0) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "协议明细ID为[" + agrItemDetailBo.getAgrItemId() + "]的协议明细状态为[停用]");
                }
            });
        }

        //4 调用协议明细价格执行列表查询方法
        AgrItemListPriceExecutionQryReqPageBo itemListPriceExecutionQryReqPageBo = new AgrItemListPriceExecutionQryReqPageBo();
        itemListPriceExecutionQryReqPageBo.setPageNo(-1);
        itemListPriceExecutionQryReqPageBo.setPageSize(-1);
        itemListPriceExecutionQryReqPageBo.setAgrItemIds(agrItemIds);
        itemListPriceExecutionQryReqPageBo.setAuditStatus(2);
        AgrItemListPriceExecutionQryRspPageBo agrItemListPriceExecutionQryRspPageBo = this.iAgrAgrModel.getAgrItemPriceExecutionList(itemListPriceExecutionQryReqPageBo);
        if (CollectionUtil.isNotEmpty(agrItemListPriceExecutionQryRspPageBo.getRows())) {
            Map<Long, List<AgrItemPriceExecutionBo>> agrItemPriceExecutionBoMap =
                    agrItemListPriceExecutionQryRspPageBo.getRows().stream().collect(Collectors.groupingBy(AgrItemPriceExecutionBo::getAgrItemId));
            agrItemListQryRspPageBo.getRows().forEach(agrItemDetailBo -> {
                if (agrItemPriceExecutionBoMap.containsKey(agrItemDetailBo.getAgrItemId())) {
                    agrItemDetailBo.setAgrItemPriceExecutionBoList(agrItemPriceExecutionBoMap.get(agrItemDetailBo.getAgrItemId()));
                }
            });
        }
        agrItemListQryRspPageBo.getRows().forEach(agrItemDetailBo -> {
            log.debug("agrItemDetailBo:{}", JSONObject.toJSONString(agrItemDetailBo));
            if (finalAgrMap.containsKey(agrItemDetailBo.getAgrId())) {
                agrItemDetailBo.setWhetherStorePlan(finalAgrMap.get(agrItemDetailBo.getAgrId()).getWhetherStorePlan());
                agrItemDetailBo.setSupplierId(finalAgrMap.get(agrItemDetailBo.getAgrId()).getSupplierId());
                agrItemDetailBo.setSupplierName(finalAgrMap.get(agrItemDetailBo.getAgrId()).getSupplierName());
                //通过协议状态改写协议明细状态值
                if (!finalAgrMap.get(agrItemDetailBo.getAgrId()).getAgrStatus().equals(AgrCommConstant.AgreementStatus.ENABLE)) {
                    agrItemDetailBo.setAgrItemStatus(0);
                }
                if (!ObjectUtil.isEmpty(agrItemDetailBo.getAgrItemPriceExecutionBoList())) {
                    List<AgrItemPriceExecutionBo> agrItemPriceExecutionBoList
                            = agrItemDetailBo.getAgrItemPriceExecutionBoList().stream()
                            .sorted(Comparator.comparing(AgrItemPriceExecutionBo::getExecutionEffDate).reversed())
                            .collect(Collectors.toList());
                    agrItemDetailBo.setAgrItemPriceExecutionBoList(agrItemPriceExecutionBoList);
                }
            }
        });
        return JSONObject.parseObject(JSONObject.toJSONString(agrItemListQryRspPageBo), AgrGetAgrItemListCheckRspBo.class);
    }

    /**
     * 入参校验
     *
     * @param reqBO
     */
    private void virifyReq(AgrGetAgrItemListCheckReqBo reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getAgrItemNumInfoList())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议明细信息集合]不能为空");
        }
        if (null == reqBO.getReturnFlag()) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[返回标识]不能为空");
        }
        if (1 != reqBO.getReturnFlag() && 2 != reqBO.getReturnFlag()) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[返回标识]类型错误");
        }
    }
}
