package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListPriceExecutionQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListPriceExecutionQryRspPageBo;
import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemPriceExecutionPageListReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemPriceExecutionPageListRspBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题：AgrGetAgrItemPriceExecutionPageListServiceImpl
 * 说明：查询协议明细价格执行列表服务实现
 * 时间：2024/7/16 16:04
 *
 * @author 周钰焱
 */
@HTServiceImpl
public class AgrGetAgrItemPriceExecutionPageListServiceImpl implements AgrGetAgrItemPriceExecutionPageListService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;

    @Override
    public AgrGetAgrItemPriceExecutionPageListRspBo getAgrItemPriceExecutionPageList(AgrGetAgrItemPriceExecutionPageListReqBo reqBo) {
        validParam(reqBo);
        AgrItemListPriceExecutionQryReqPageBo itemListPriceExecutionQryReqPageBo = new AgrItemListPriceExecutionQryReqPageBo();
        itemListPriceExecutionQryReqPageBo.setAgrItemId(reqBo.getAgrItemId());
        itemListPriceExecutionQryReqPageBo.setPageNo(reqBo.getPageNo());
        itemListPriceExecutionQryReqPageBo.setPageSize(reqBo.getPageSize());
        AgrItemListPriceExecutionQryRspPageBo agrItemPriceExecutionList = iAgrAgrModel.getAgrItemPriceExecutionList(itemListPriceExecutionQryReqPageBo);

        AgrGetAgrItemPriceExecutionPageListRspBo rspBo = JSONObject.parseObject(JSONObject.toJSONString(agrItemPriceExecutionList), AgrGetAgrItemPriceExecutionPageListRspBo.class);
        //4 翻译转义
        List<String> pCodeList = new ArrayList<>();
        pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_PRICE_EXECUTION_STATUS);
        Map<String, Map<String, DicDictionaryBo>> dicMap = this.iAgrDictionaryModel.selectByPCodeListToMap(pCodeList);
        if (!CollectionUtils.isEmpty(rspBo.getRows())) {
            rspBo.getRows().forEach(x -> x.setAuditStatusStr(
                    MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_PRICE_EXECUTION_STATUS)) ? null :
                            dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_ITEM_PRICE_EXECUTION_STATUS).get(x.getAuditStatus().toString()).getTitle())
            );
        }
        return rspBo;
    }


    /**
     * 校验重复
     */
    private void validParam(AgrGetAgrItemPriceExecutionPageListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_OBJ_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getAgrItemId() == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_OBJ_EMPTY_ERROR, "协议明细ID不能为空");
        }
    }
}
