package com.tydic.dyc.agr.service.agr;

import com.tydic.dyc.agr.model.common.AgrCommonDo;
import com.tydic.dyc.agr.model.common.IAgrCommonModel;
import com.tydic.dyc.agr.model.common.qrybo.AgrBatchDealRecordQryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetBatchDealRecordListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetBatchDealRecordListRspBO;
import com.tydic.dyc.agr.service.agr.bo.ComBatchDealRrecordBo;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * 标题:AgrGetBatchDealRecordListServiceImpl
 * 说明:TODO
 * 时间:2023/4/13 17:32
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrGetBatchDealRecordListServiceImpl implements AgrGetBatchDealRecordListService {
    @Autowired
    private IAgrCommonModel iAgrCommonModel;
    @Override
    public AgrGetBatchDealRecordListRspBO getBatchDealRecordList(AgrGetBatchDealRecordListReqBO agrGetBatchDealRecordListReqBO) {
        AgrGetBatchDealRecordListRspBO rspBO = AgrRu.success(AgrGetBatchDealRecordListRspBO.class);
        AgrBatchDealRecordQryBo agrBatchDealRecordQryBo = AgrRu.js(agrGetBatchDealRecordListReqBO,AgrBatchDealRecordQryBo.class);
        AgrCommonDo agrCommonDo = this.iAgrCommonModel.getBatchDealRecordList(agrBatchDealRecordQryBo);
        if(agrCommonDo!=null && !CollectionUtils.isEmpty(agrCommonDo.getComBatchDealRrecord())){
            rspBO.setRows(AgrRu.jsl(agrCommonDo.getComBatchDealRrecord(), ComBatchDealRrecordBo.class));
        }
        return rspBO;
    }
}
