/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAgrVersion;
import com.tydic.dyc.agr.service.agr.AgrAgrAddAuditCallBackService;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrAddAuditCallBackReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrAddAuditCallBackRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrAgrAddAuditCallBackService"})
public class AgrAgrAddAuditCallBackServiceImpl
implements AgrAgrAddAuditCallBackService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"dealAgrAddAuditCallBack"})
    public AgrAgrAddAuditCallBackRspBO dealAgrAddAuditCallBack(@RequestBody AgrAgrAddAuditCallBackReqBO reqBO) {
        this.updateAgrMain(reqBO.getAgrId());
        this.saveAgrVersion(reqBO);
        return AgrRu.success(AgrAgrAddAuditCallBackRspBO.class);
    }

    private void updateAgrMain(Long agrId) {
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(agrId);
        AgrAgrDo agrAgrDoDetail = this.iAgrAgrModel.getAgrMain(agrAgrQryBo);
        Date effDate = agrAgrDoDetail.getEffDate();
        Date date = new Date();
        if (ObjectUtil.isNull((Object)effDate)) {
            agrAgrDo.setEffDate(date);
            agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.ENABLE);
        } else {
            int i = date.compareTo(effDate);
            if (i < 0) {
                agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.WAIT_ENABLE);
            } else {
                agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.ENABLE);
            }
        }
        if (ObjectUtil.isNotNull((Object)agrAgrDoDetail.getExpDate()) && date.compareTo(agrAgrDoDetail.getExpDate()) >= 0) {
            agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.BE_OVERDUE);
        }
        if (agrAgrDoDetail.getAgrType().equals(AgrCommConstant.AgrType.AGR)) {
            agrAgrDo.setAgrMainExtend5("1");
            agrAgrDo.setWhetherStorePlan(AgrCommConstant.WhetherStorePlanEnum.WHETHER_STORE_PLAN_YES.getValue());
        } else {
            agrAgrDo.setAgrVersion("V1");
        }
        agrAgrDo.setAgrId(agrId);
        this.iAgrAgrModel.updateAgrMain(agrAgrDo);
    }

    private void saveAgrVersion(AgrAgrAddAuditCallBackReqBO reqBO) {
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(reqBO.getAgrId());
        AgrAgrDo agrAgrDoDetail = this.iAgrAgrModel.getAgrMain(agrAgrQryBo);
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        ArrayList<AgrAgrVersion> agrAgrVersions = new ArrayList<AgrAgrVersion>();
        AgrAgrVersion AgrAgrVersion2 = new AgrAgrVersion();
        AgrAgrVersion2.setAgrId(agrAgrDoDetail.getAgrId());
        AgrAgrVersion2.setAgrCode(agrAgrDoDetail.getAgrCode());
        AgrAgrVersion2.setCreateTime(new Date());
        AgrAgrVersion2.setChngType(AgrCommConstant.AgreementChangeType.ORGINAL);
        AgrAgrVersion2.setVersionStatus(AgrCommConstant.AgrVersionStatus.VALID);
        AgrAgrVersion2.setAgrVersion("V1");
        AgrAgrVersion2.setChngApplyCreateTime(agrAgrDoDetail.getCreateTime());
        AgrAgrVersion2.setRelCode(agrAgrDoDetail.getRelCode());
        agrAgrVersions.add(AgrAgrVersion2);
        agrAgrDo.setAgrAgrVersion(agrAgrVersions);
        agrAgrDo.setAgrId(agrAgrDoDetail.getAgrId());
        this.iAgrAgrModel.saveAgrVersion(agrAgrDo);
    }
}

