/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.AgrDealAgrItemPurNumService;
import com.tydic.dyc.agr.service.agr.bo.AgrDealAgrItemPurNumBo;
import com.tydic.dyc.agr.service.agr.bo.AgrDealAgrItemPurNumReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrDealAgrItemPurNumRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrDealAgrItemPurNumService"})
public class AgrDealAgrItemPurNumServiceImpl
implements AgrDealAgrItemPurNumService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    private static final Integer PUR_NUM_OPER_TYPE_DEDUCT = 1;
    private static final Integer PUR_NUM_OPER_TYPE_RETURN = 2;

    @PostMapping(value={"dealAgrItemPurNum"})
    public AgrDealAgrItemPurNumRspBo dealAgrItemPurNum(@RequestBody AgrDealAgrItemPurNumReqBo reqBo) {
        AgrDealAgrItemPurNumRspBo rspBo = new AgrDealAgrItemPurNumRspBo();
        this.virifyReq(reqBo);
        List<Long> agrIds = reqBo.getAgrDealAgrItemPurNumBoList().stream().map(AgrDealAgrItemPurNumBo::getAgrId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> agrItemIds = reqBo.getAgrDealAgrItemPurNumBoList().stream().map(AgrDealAgrItemPurNumBo::getAgrItemId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrIds(agrIds);
        agrAgrQryBo.setPageNo(-1);
        agrAgrQryBo.setPageSize(-1);
        AgrGetAgrMainListRspQryBo agrMainList = this.iAgrAgrModel.getAgrMainList(agrAgrQryBo);
        if (agrIds.size() != agrMainList.getRows().size()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8bae\u660e\u7ec6\u91c7\u8d2d\u6570\u91cf\u64cd\u4f5c\u4fe1\u606f\u96c6\u5408]\u534f\u8baeID\u96c6\u5408\u4e0e\u534f\u8bae\u4e3b\u8868\u96c6\u5408\u4e0d\u4e00\u81f4");
        }
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
        agrItemListQryReqPageBo.setAgrItemIds(agrItemIds);
        agrItemListQryReqPageBo.setPageNo(-1);
        agrItemListQryReqPageBo.setPageSize(-1);
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.qryAgrItemList(agrItemListQryReqPageBo);
        if (agrItemIds.size() != agrItemListQryRspPageBo.getRows().size()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8bae\u660e\u7ec6\u91c7\u8d2d\u6570\u91cf\u64cd\u4f5c\u4fe1\u606f\u96c6\u5408]\u534f\u8bae\u660e\u7ec6ID\u96c6\u5408\u4e0e\u534f\u8bae\u660e\u7ec6\u5217\u8868\u96c6\u5408\u4e0d\u4e00\u81f4");
        }
        AgrAgrDo agrDo = new AgrAgrDo();
        ArrayList<AgrItem> agrItemList = new ArrayList<AgrItem>(reqBo.getAgrDealAgrItemPurNumBoList().size());
        Map<Long, AgrItem> agrItemMap = agrItemListQryRspPageBo.getRows().stream().collect(Collectors.toMap(AgrItem::getAgrItemId, agrItem -> agrItem, (k1, k2) -> k1));
        Map<Long, List<AgrDealAgrItemPurNumBo>> reqAgrItemIdMap = reqBo.getAgrDealAgrItemPurNumBoList().stream().collect(Collectors.groupingBy(AgrDealAgrItemPurNumBo::getAgrItemId));
        List duplicateIds = reqAgrItemIdMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!duplicateIds.isEmpty()) {
            HashMap<Long, AgrDealAgrItemPurNumBo> idBoMap = new HashMap<Long, AgrDealAgrItemPurNumBo>();
            for (AgrDealAgrItemPurNumBo bo : reqBo.getAgrDealAgrItemPurNumBoList()) {
                idBoMap.compute(bo.getAgrItemId(), (id, existingBo) -> {
                    if (existingBo == null) {
                        return bo;
                    }
                    existingBo.setOperNum(existingBo.getOperNum().add(bo.getOperNum()));
                    return existingBo;
                });
            }
            ArrayList newAgrItemList = new ArrayList(idBoMap.values());
            if (PUR_NUM_OPER_TYPE_DEDUCT.equals(reqBo.getOperType())) {
                newAgrItemList.forEach(agrDealAgrItemPurNumBo -> {
                    AgrItem agrItemUpdate = new AgrItem();
                    AgrItem agrItem = (AgrItem)agrItemMap.get(agrDealAgrItemPurNumBo.getAgrItemId());
                    if (agrItem.getIsControlPurchaseNum() == 1 && agrDealAgrItemPurNumBo.getOperNum().compareTo(agrItem.getLeftNumber()) > 0) {
                        throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8bae\u660e\u7ec6\u91c7\u8d2d\u6570\u91cf\u64cd\u4f5c\u4fe1\u606f\u96c6\u5408]\u534f\u8bae\u660e\u7ec6\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u534f\u8bae\u660e\u7ec6\u5269\u4f59\u53ef\u6267\u884c\u6570\u91cf");
                    }
                    agrItemUpdate.setAgrItemId(agrDealAgrItemPurNumBo.getAgrItemId());
                    agrItemUpdate.setExecutedNumber(agrItem.getExecutedNumber().add(agrDealAgrItemPurNumBo.getOperNum()));
                    agrItemUpdate.setLeftNumber(agrItem.getLeftNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : agrItem.getLeftNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()));
                    agrItemList.add(agrItemUpdate);
                });
            }
            if (PUR_NUM_OPER_TYPE_RETURN.equals(reqBo.getOperType())) {
                newAgrItemList.forEach(agrDealAgrItemPurNumBo -> {
                    AgrItem agrItemUpdate = new AgrItem();
                    AgrItem agrItem = (AgrItem)agrItemMap.get(agrDealAgrItemPurNumBo.getAgrItemId());
                    agrItemUpdate.setAgrItemId(agrDealAgrItemPurNumBo.getAgrItemId());
                    agrItemUpdate.setExecutedNumber(agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()));
                    if (agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()).compareTo(agrItem.getBuyNumber()) >= 0) {
                        agrItemUpdate.setLeftNumber(BigDecimal.ZERO);
                    } else {
                        agrItemUpdate.setLeftNumber(agrItem.getBuyNumber().subtract(agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum())));
                    }
                    agrItemList.add(agrItemUpdate);
                });
            }
            agrDo.setAgrItem(agrItemList);
            this.iAgrAgrModel.updateAgrItemByBatch(agrDo);
        } else {
            if (PUR_NUM_OPER_TYPE_DEDUCT.equals(reqBo.getOperType())) {
                reqBo.getAgrDealAgrItemPurNumBoList().forEach(agrDealAgrItemPurNumBo -> {
                    AgrItem agrItemUpdate = new AgrItem();
                    AgrItem agrItem = (AgrItem)agrItemMap.get(agrDealAgrItemPurNumBo.getAgrItemId());
                    if (agrItem.getIsControlPurchaseNum() == 1 && agrDealAgrItemPurNumBo.getOperNum().compareTo(agrItem.getLeftNumber()) > 0) {
                        throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8bae\u660e\u7ec6\u91c7\u8d2d\u6570\u91cf\u64cd\u4f5c\u4fe1\u606f\u96c6\u5408]\u534f\u8bae\u660e\u7ec6\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u534f\u8bae\u660e\u7ec6\u5269\u4f59\u53ef\u6267\u884c\u6570\u91cf");
                    }
                    agrItemUpdate.setAgrItemId(agrDealAgrItemPurNumBo.getAgrItemId());
                    agrItemUpdate.setExecutedNumber(agrItem.getExecutedNumber().add(agrDealAgrItemPurNumBo.getOperNum()));
                    agrItemUpdate.setLeftNumber(agrItem.getLeftNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : agrItem.getLeftNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()));
                    agrItemList.add(agrItemUpdate);
                });
            }
            if (PUR_NUM_OPER_TYPE_RETURN.equals(reqBo.getOperType())) {
                reqBo.getAgrDealAgrItemPurNumBoList().forEach(agrDealAgrItemPurNumBo -> {
                    AgrItem agrItemUpdate = new AgrItem();
                    AgrItem agrItem = (AgrItem)agrItemMap.get(agrDealAgrItemPurNumBo.getAgrItemId());
                    agrItemUpdate.setAgrItemId(agrDealAgrItemPurNumBo.getAgrItemId());
                    agrItemUpdate.setExecutedNumber(agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()));
                    if (agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum()).compareTo(agrItem.getBuyNumber()) >= 0) {
                        agrItemUpdate.setLeftNumber(BigDecimal.ZERO);
                    } else {
                        agrItemUpdate.setLeftNumber(agrItem.getBuyNumber().subtract(agrItem.getExecutedNumber().subtract(agrDealAgrItemPurNumBo.getOperNum())));
                    }
                    agrItemList.add(agrItemUpdate);
                });
            }
            agrDo.setAgrItem(agrItemList);
            this.iAgrAgrModel.updateAgrItemByBatch(agrDo);
        }
        return rspBo;
    }

    private void virifyReq(AgrDealAgrItemPurNumReqBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getAgrDealAgrItemPurNumBoList())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8bae\u660e\u7ec6\u91c7\u8d2d\u6570\u91cf\u64cd\u4f5c\u4fe1\u606f\u96c6\u5408]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperType()) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u64cd\u4f5c\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!PUR_NUM_OPER_TYPE_DEDUCT.equals(reqBO.getOperType()) && !PUR_NUM_OPER_TYPE_RETURN.equals(reqBO.getOperType())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u64cd\u4f5c\u7c7b\u578b]\u9519\u8bef");
        }
    }
}

