/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.service.agr.AgrUnifyTodoQryAbilityService;
import com.tydic.dyc.agr.service.agr.bo.AgrUnifyTodoQryAbilityReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrUnifyTodoQryAbilityRspBO;
import com.tydic.dyc.agr.service.auditorder.bo.AgrGetAuditToDoInfoReqBO;
import com.tydic.dyc.agr.service.auditorder.bo.AgrGetAuditToDoInfoRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrUnifyTodoQryAbilityService"})
public class AgrUnifyTodoQryAbilityServiceImpl
implements AgrUnifyTodoQryAbilityService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;

    @PostMapping(value={"qryTodoInfo"})
    public AgrUnifyTodoQryAbilityRspBO qryTodoInfo(@RequestBody AgrUnifyTodoQryAbilityReqBO reqBO) {
        AgrUnifyTodoQryAbilityRspBO rspBO = AgrRu.success(AgrUnifyTodoQryAbilityRspBO.class);
        String checkResult = this.check(reqBO);
        if (!StringUtils.isEmpty((CharSequence)checkResult)) {
            throw new ZTBusinessException(checkResult);
        }
        switch (reqBO.getObjType()) {
            case 1: {
                this.getAgrInfo(reqBO.getObjId(), rspBO);
                if (StringUtils.isEmpty((CharSequence)rspBO.getParamJson())) break;
                JSONObject paramJson = JSONObject.parseObject((String)rspBO.getParamJson());
                paramJson.put("confirmType", (Object)"1");
                rspBO.setParamJson(JSONObject.toJSONString((Object)paramJson));
                break;
            }
            case 2: {
                this.getAgrChngInfo(reqBO.getObjId(), rspBO);
                if (StringUtils.isEmpty((CharSequence)rspBO.getParamJson())) break;
                JSONObject paramJson = JSONObject.parseObject((String)rspBO.getParamJson());
                paramJson.put("confirmType", (Object)"2");
                rspBO.setParamJson(JSONObject.toJSONString((Object)paramJson));
                break;
            }
            case 9: {
                AgrGetAuditToDoInfoReqBO agrGetAuditToDoInfoReqBO = new AgrGetAuditToDoInfoReqBO();
                agrGetAuditToDoInfoReqBO.setObjId(reqBO.getObjId());
                AgrGetAuditToDoInfoRspBO agrGetAuditToDoInfoRspBO = this.iAgrAuditOrderModel.getAuditTodoInfo(agrGetAuditToDoInfoReqBO);
                if (agrGetAuditToDoInfoRspBO == null) break;
                if (AgrCommConstant.ObjType.AGREEMENT.equals(agrGetAuditToDoInfoRspBO.getDataType())) {
                    this.getAgrInfo(agrGetAuditToDoInfoRspBO.getAgrId(), rspBO);
                } else if (AgrCommConstant.ObjType.CHANGE.equals(agrGetAuditToDoInfoRspBO.getDataType())) {
                    this.getAgrChngInfo(agrGetAuditToDoInfoRspBO.getChngApplyId(), rspBO);
                }
                if (StringUtils.isEmpty((CharSequence)rspBO.getParamJson())) break;
                JSONObject paramJson = JSONObject.parseObject((String)rspBO.getParamJson());
                paramJson.put("taskId", (Object)agrGetAuditToDoInfoRspBO.getTaskId());
                paramJson.put("procInstId", (Object)agrGetAuditToDoInfoRspBO.getProcInstId());
                paramJson.put("auditOrderCode", (Object)agrGetAuditToDoInfoRspBO.getAuditOrderCode());
                rspBO.setParamJson(JSONObject.toJSONString((Object)paramJson));
                break;
            }
            default: {
                throw new ZTBusinessException("\u9519\u8bef\u7684\u5355\u636e\u7c7b\u578b");
            }
        }
        return rspBO;
    }

    private String check(AgrUnifyTodoQryAbilityReqBO reqBO) {
        String checkMsg = "";
        if (reqBO.getShareId() == null) {
            checkMsg = "\u5206\u5e93\u952eID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getObjId() == null) {
            checkMsg = "\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getObjType() == null) {
            checkMsg = "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return checkMsg;
    }

    private void getAgrInfo(Long agrId, AgrUnifyTodoQryAbilityRspBO rspBO) {
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(agrId);
        AgrAgrDo agrAgrDo = this.iAgrAgrModel.getAgrMain(agrAgrQryBo);
        if (agrAgrDo == null) {
            throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u534f\u8bae\u4fe1\u606f");
        }
        rspBO.setObjCreateUserId(agrAgrDo.getCreateLoginId());
        rspBO.setProOrgId(null);
        rspBO.setPurOrgId(agrAgrDo.getPurchaseOrgId());
        rspBO.setSupOrgId(agrAgrDo.getSupplierId());
        JSONObject paramJson = new JSONObject();
        paramJson.put("agrId", (Object)agrAgrDo.getAgrId());
        paramJson.put("agrCode", (Object)agrAgrDo.getAgrCode());
        paramJson.put("busiObjType", (Object)1);
        paramJson.put("agrType", (Object)agrAgrDo.getAgrType());
        rspBO.setParamJson(JSONObject.toJSONString((Object)paramJson));
    }

    private void getAgrChngInfo(Long chngApplyId, AgrUnifyTodoQryAbilityRspBO rspBO) {
        AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new AgrAgrChngApplyQryBo();
        agrAgrChngApplyQryBo.setChngApplyId(chngApplyId);
        AgrChngApplyDo agrChngApplyDo = this.iAgrChngApplyModel.getAgrMainChng(agrAgrChngApplyQryBo);
        if (agrChngApplyDo != null) {
            rspBO.setObjCreateUserId(agrChngApplyDo.getCreateLoginId());
            rspBO.setProOrgId(null);
            if (agrChngApplyDo.getAgrMainChng() != null) {
                rspBO.setPurOrgId(agrChngApplyDo.getAgrMainChng().getPurchaseOrgId());
                rspBO.setSupOrgId(agrChngApplyDo.getAgrMainChng().getSupplierId());
            } else {
                AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
                agrAgrQryBo.setAgrId(agrChngApplyDo.getAgrId());
                AgrAgrDo agrAgrDo = this.iAgrAgrModel.getAgrMain(agrAgrQryBo);
                rspBO.setPurOrgId(agrAgrDo.getPurchaseOrgId());
                rspBO.setSupOrgId(agrAgrDo.getSupplierId());
            }
        } else {
            throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u534f\u8bae\u53d8\u66f4\u4fe1\u606f");
        }
        JSONObject paramJson = new JSONObject();
        paramJson.put("agrId", (Object)agrChngApplyDo.getAgrId());
        paramJson.put("agrCode", (Object)agrChngApplyDo.getAgrCode());
        paramJson.put("chngApplyId", (Object)agrChngApplyDo.getChngApplyId());
        paramJson.put("chngApplyNo", (Object)agrChngApplyDo.getChngApplyNo());
        paramJson.put("busiObjType", (Object)2);
        paramJson.put("agrType", (Object)agrChngApplyDo.getAgrMainChng().getAgrType());
        rspBO.setParamJson(JSONObject.toJSONString((Object)paramJson));
    }
}

