package com.tydic.dyc.oc.service.common.bo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:UocBaseOrderAccessoryDetailBo
 * 说明:
 * 时间:2022/2/17 9:48
 * 作者:田桂银
 */
@Data
public class UocBaseOrderAccessoryDetailBo implements Serializable {

    private static final long serialVersionUID = -7208762355430916473L;

    /**
     * 附件id
     */
    private Long id;

    /**
     * 单据id      单据类型为1=订单时，不填
     */
    private Long objId;

    /**
     * 单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单 8验收单，9审批单     99.其他
     *
     */
    private Integer objType;

    /**
     * 单据类型翻译
     */
    private String objTypeStr;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 附件类型
     */
    private Integer attachmentType;

    /**
     * 附件类型翻译
     */
    private String attachmentTypeStr;

    /**
     * 附件编号
     */
    private String accessoryId;

    /**
     * 附件名称
     */
    private String accessoryName;

    /**
     * 附件url
     */
    private String accessoryUrl;

    /**
     * 附件存储位置             填附件的实际存储物理地址
     */
    private String attachmentStore;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建工号
     */
    private String createOperId;

    /**
     * 创建人
     */
    private String createOperName;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新工号
     */
    private String updateOperId;

    /**
     * 更新人
     */
    private String updateOperName;

    /**
     * 备注
     */
    private String remark;

}


