package com.tydic.dyc.oc.service.domainservice.bo;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocArchivistInspOrderBo
 * 说明:验收单
 * 时间:2022-05-20 10:11
 * 作者:罗有
 **/
@Data
public class UocArchivistInspOrderBo implements Serializable {
    private static final long serialVersionUID = 6698011628207477247L;

    //验收单id")
    private Long inspOrderId;

    //销售单id")
    private Long saleOrderId;

    //订单id")
    private Long orderId;

    //发货单编码")
    private String inspOrderNo;

    //外部发货单编码")
    private String inspOrderNoExt;

    //验收单名称")
    private String inspOrderName;

    //验收单类型")
    private Integer inspOrderType;

    //验收单状态")
    private String inspOrderState;

    //销售金额")
    private BigDecimal totalSaleFee;

    //采购金额")
    private BigDecimal totalPurchaseFee;

    //实付金额")
    private BigDecimal usedFee;

    //开票标识 0未开票 1已开票")
    private Integer invoiceTag;

    //允许变更时限")
    private Date allowChngTime;

    //允许变更时限 开始")
    private Date allowChngTimeStart;

    //允许变更时限 结束")
    private Date allowChngTimeEnd;

    //流转状态")
    private String procState;

    //对账状态")
    private String checkState;

    //租户ID")
    private String tenantId;

    //竣工标志             1 竣工             0 在途")
    private Integer finishFlag;

    //创建时间")
    private Date createTime;

    //创建工号")
    private String createOperId;

    //验收人电话")
    private String inspOperPhone;

    //验收人名字")
    private String inspOper;

    //更新时间")
    private Date updateTime;

    //更新工号")
    private String updateOperId;

    //撤单时间")
    private Date cancelTime;

    //撤单工号")
    private String cancelOperId;

    //撤单原因")
    private String cancelReason;

    //撤单标志:1 已撤单             0 未撤单")
    private Integer cancelFlag;

    //备注")
    private String remark;

    //其他备注")
    private String otherRemark;

    //竣工时间")
    private Date finishTime;

    //逾期时间")
    private Date expTime;

    //扩展字段1")
    private String extField1;

    //扩展字段2")
    private String extField2;

    //扩展字段3")
    private String extField3;

    //扩展字段4")
    private String extField4;

    //扩展字段5")
    private String extField5;

    //删除标志1已删除")
    private Integer delTag;

    //排序")
    private String orderBy;

    //供应商ID")
    private Long supId;

    //总金额")
    private BigDecimal totalFee;

    //总数量")
    private Integer totalCount;

    /**
     * 验收单支付状态，10未支付，20支付中，30已支付
     */
    private Integer payStatus;

    private List<UocArchivistInspOrderItemBo> uocArchivistInspOrderItemBoList;
}
