package com.tydic.dyc.oc.service.saleorder.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class UocSendEcPlatOrderBO implements Serializable {
    private static final long serialVersionUID = 4707334901684958135L;
    //销售单id")
    private Long saleOrderId;
    //销售单编码")
    private String saleOrderNo;
    //销售明细id")
    private Long saleOrderItemId;
    //sap订单编号
    private String sapOrderNo;

    //sap 订单明细编号
    private String sapOrderItemNo;
    //单品编码")
    private String skuCode;

    //单品名称")
    private String skuName;
    //销售金额")
    private BigDecimal salePrice;
    //采购数量")
    private BigDecimal purchaseCount;
    //创建工号")
    private String createOperId;
    //创建人名称")
    private String createOperName;
    //创建人登录名称")
    private String createOperLoginName;
    //订单状态")
    private String saleOrderState;
    /**
     * 汇总人id
     */
    private String collectId;
    /**
     * 汇总人名称
     */
    private String collectName;
    /**
     * 汇总人登录名
     */
    private String collectLoginName;
    /**
     * 订单审批通过时间
     */
    private String orderAuditTime;

    //订单状态翻译")
    private String saleOrderStateStr;
    //销售金额")
    private BigDecimal totalSaleFee;
    //创建时间")
    private Date orderCreateTime;
    //计量单位")
    private String unitName;
    /**
     * 供应商id
     */
    private String supplierId;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 专区类型 1-工业品；2-办公用品
     */
    private String areaType;
    //采购方公司id")
    private String purCompanyId;

    //采购方公司名称")
    private String purCompanyName;

    //采购方机构id")
    private String purOrgId;

    //采购方机构名称")
    private String purOrgName;

    /**
     * 采购单位编码
     */
    private String extCompanyCode;
    /**
     * 计划明辨编号
     */
    private String purchaseNo;
    /**
     * 物料编码
     */
    private String purchaseCode;
}
