package com.tydic.dyc.oc.model.saleorder.sub;

import com.tydic.dyc.base.bo.BaseExtendBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtCrossBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqAccessoryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderPlanBO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocSaleOrderItem
 * 说明:销售订单明细
 * 时间:2022-02-21 19:11
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper = false)
public class UocSaleOrderItem extends BaseExtendBo {
    private static final long serialVersionUID = -1930014495446916868L;

    //订单id")
    private Long orderId;

    //销售明细id")
    private Long saleOrderItemId;

    //明细序号
    private String saleOrderItemIndex;

    //销售单id")
    private Long saleOrderId;

    //订单明细id")
    private Long orderItemId;

    //sap订单编号
    private String sapOrderNo;

    //sap 订单明细编号
    private String sapOrderItemNo;

    //比选单号")
    private String cmpOrderNo;

    //明细类型             1 商品sku             2 物资             3 项目")
    private Integer itemType;

    //商品来源，区分电商、协议、无协议", required = true, valArg = "商品来源")
    private Integer skuSource;

    //明细类型翻译")
    private String itemTypeStr;

    //明细状态")
    private String saleItemState;

    //发货单明细状态")
    private String shipItemState;

    //单品ID")
    private String skuId;

    //单品编码")
    private String skuCode;

    //单品名称")
    private String skuName;

    //商品id")
    private String commodityId;

    //商品名称")
    private String commodityName;

    //商品类型id")
    private String commodityTypeId;

    //商品类型名称")
    private String commodityTypeName;

    //供应商ID")
    private String supplierId;

    //店铺ID")
    private String supplierShopId;

    //采购金额")
    private BigDecimal purchasePrice;

    //销售金额")
    private BigDecimal salePrice;

    //总销售金额")
    private BigDecimal totalSaleFee;

    //采购数量")
    private BigDecimal purchaseCount;

    //运费")
    private BigDecimal transFee;

    //采购金额")
    private BigDecimal purchaseFee;

    //应付金额")
    private BigDecimal payFee;

    //积分优惠金额")
    private BigDecimal integralDisFee;

    //活动优惠金额")
    private BigDecimal actDisFee;

    //其它优惠金额")
    private BigDecimal otherDisFee;

    //实付金额")
    private BigDecimal usedFee;

    //实付积分")
    private BigDecimal usedIntegral;

    //币种")
    private String currencyType;

    //税金")
    private BigDecimal taxPrice;

    //税率")
    private BigDecimal tax;

    //税务编码")
    private String taxId;

    //预计发货时间")
    private Date preSendTime;

    //预计交货时间")
    private Date preOfferTime;

    //计量单位")
    private String unitName;

    //结算计量单位")
    private String settleUnit;

    //售后在途数量")
    private BigDecimal afterServingCount;

    //外部电商主订单id")
    private String lmOrderId;

    //外部电商子订单id")
    private String lmSubOrderId;

    //到货周期")
    private String arrivalTime;

    //加价率")
    private Double markUpRate;

    //商品服务费 ")
    private String serPrice;

    //京能新增参数开始  ///////////////////////////
    /**
     * 计划ID
     */
    private String planId;
    /**
     * 计划编号
     */
    private String planNo;
    /**
     * 计划明细ID
     */
    private String planItemId;
    /**
     * 计划明细编号
     */
    private String planItemNo;
    /**
     * 计划来源1SAP;2电商平台
     */
    private Integer planSource;
    /**
     * 计划单位
     */
    private String planUnit;
    /**
     * 单位转换倍率
     */
    private BigDecimal planConversionRate;
    //京能新增参数开始  ///////////////////////////

    //协议id")
    private String agreementId;

    //协议编号")
    private String agreementNo;

    //协议模式 1：平台协议 2：单位协议")
    private Integer agreementCode;

    //协议明细编号")
    private String agreementIdItemNo;

    //创建时间")
    private Date createTime;

    //创建工号")
    private String createOperId;

    //更新时间")
    private Date updateTime;

    //更新工号")
    private String updateOperId;

    //备注")
    private String remark;

    //超验百分比，下单时保存（协议、无协议）")
    private Integer inspectionExcessPercent;

    //销售单明细扩展")
    private List<UocSaleItemMap> saleItemMapList;

    //销售单明细横向扩展数据")
    private UocBaseExtCrossBo extCrossBo;

    //sku物料ID")
    private String skuMaterialId;

    //sku物料编码")
    private String skuMaterialCode;

    //sku外部单品id")
    private String skuExtSkuId;

    //sku品牌id")
    private Long skuBrandId;

    //单品品牌名称")
    private String skuBrandName;

    //sku明细id")
    private String skuItemId;

    //sku物料名称")
    private String skuMaterialName;

    //sku物料类型名称")
    private String skuMaterialTypeName;

    //sku物料类型id")
    private String skuMaterialTypeId;

    //型号")
    private String model;

    //规格")
    private String spec;

    //材质")
    private String texture;

    //图号")
    private String figure;

    //一级类目")
    private Long l1Catalog;

    //二级类目")
    private Long l2Catalog;

    //三级类目")
    private Long l3Catalog;

    //一级类目名称")
    private String l1CatalogName;

    //二级类目名称")
    private String l2CatalogName;

    //三级类目名称")
    private String l3CatalogName;

    //退货时间，空代表不支持")
    private Integer rejectAllowDate;

    //换货时间，空代表不支持")
    private Integer exchangeAllowDate;

    //维修时间，空代表不支持")
    private Integer maintainAllowDate;

    //sku单品主图url")
    private String skuMainPicUrl;

    //是否存在超验 0否 1是")
    private Integer inspSuper;

    //到货时间")
    private Date arriveTime;

    //发货数量")
    private BigDecimal sendCount;

    //验收数量")
    private BigDecimal acceptanceCount;



    //退货数量")
    private BigDecimal returnCount;

    //到货数量")
    private BigDecimal arriveCount;

    //拒收数量")
    private BigDecimal refuseCount;

    //异常变更在途数量")
    private BigDecimal chngingCount;

    //订单IDList")
    private List<Long> orderIdList;


    //销售单IdList")
    private List<Long> saleOrderItemsIdList;

    //销售金额")
    private BigDecimal saleFee;

    //裸价")
    private BigDecimal nakedPrice;

    //超验数量")
    private BigDecimal inspSuperCount;

    //商品编码
    //商品编码")
    private String commodityCode;

    /**
     * 未比选原因
     */
    private String noCmpReason;
    /**
     * 供货周期
     */
    private String deliveryTimeDate;
    /**
     * 供应商+结算模式key
     */
    private String supplierIdModelSettelKey;
    /**
     * 拒收评价标识
     */
    private String evaSign;

    /**
     * 协议bo，协议商品必传（根据协议id是否为空来判断）
     */
    private UocOrderAgreement agrBo;
    /**
     * 计量单位位数
     */
    private String unitDigit;

    /**
     * 商品支持售后返回方式
     */
    private List<Integer> serverReturnTypeList;

    //商品关联计划明细列表
    private List<UocOrderPlanBO> orderPlanBOList;


    /**
     * 议价单id
     */
    private Long bargainingId;
    /**
     * 议价单编码
     */
    private String bargainingNo;

    /**
     * 铺货单位ID
     */
    private String managementOrgId;
    /**
     * 铺货单位名称
     */
    private String managementOrgName;
    /**
     * 协议价格明细执行时间
     */
    private Date agrItemActiveTime;
    /**
     * 协议价格明细创建时间
     */
    private Date agrItemCreateTime;
    /**
     * 协议价格明细不含税单价
     */
    private BigDecimal agrItemNoTaxPrice;
    /**
     * 订单附件信息
     */
    private List<UocOrderAccessory> attachBos;
    //临时验收状态
    private Integer isTempAccept;

    /**
     * 分配标识  1.已分配 2.待分配
     */
    private Integer allocationFlag;

    /**
     * 分配人ID
     */
    private String allocationUserId;

    /**
     * 分配人ID
     */
    private String allocationName;

    /**
     * 核查结果  1.未核查 2.问题商品 3.超时未核查
     */
    private Integer checkFlag;

    /**
     * 核查人ID
     */
    private String checkUserId;

    /**
     * 核查人名称
     */
    private String checkName;

    /**
     * 问题商品记录ID
     */
    private Long problemSaleItemId;

    /**
     * 价格异常商品标识  1.异常商品，0未异常商品 2.已提交反馈单
     */
    private Integer priceAbnormalFlag;

    /**
     * 商品核查价
     */
    private BigDecimal goodCheckPrice;

    /**
     * 罚款系数
     */
    private BigDecimal penaltyCoefficient;

    /**
     * 追加罚款
     */
    private BigDecimal penaltyFee;

    /**
     * 是否追加罚款  1.已追加 2.无需追加
     */
    private Integer isPenaltyFlag;

    /**
     * 是否追加罚款说明
     */
    private String isPenaltyDesc;

    /**
     * 反馈单ID
     */
    private String feedbackId;
    //创建时间")
    private Date createTimeStart;
    //创建时间")
    private Date createTimeEnd;
    /**
     * 反馈单编号
     */
    private String feedbackNo;
    /**
     * 反馈单状态值
     */
    private String feedbackStateCode;
    /**
     * 反馈单状态名称
     */
    private String feedbackStateName;
    /**
     * 官网价
     */
    private String internetPrice;

    /**
     * 指导价
     */
    private String guidePrice;
    /**
     * 分配时间
     */
    private Date allocationTime;

    //推送价格")
    private BigDecimal marketPrice;
}
