package com.tydic.dyc.oc.service.cmporder;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderQryBo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocUpdateCmpOrderBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocDelCmpOrderServiceReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocUpdateCmpOrderServiceReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocUpdateCmpOrderServiceRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * UocUpdateCmpOrderServiceImpl
 * 2023/3/1
 * Project:dyc-uoc-pro
 * Creator:印昌盛
 * Create Time:2023/3/1-22-17
 * 描述：更新比选单
 */
@HTServiceImpl
public class UocUpdateCmpOrderServiceImpl implements UocUpdateCmpOrderService{
    @Autowired
    private IUocCmpOrderModel uocCmpOrderModel;
    @Override
    public UocUpdateCmpOrderServiceRspBo updateCmpOrder(UocUpdateCmpOrderServiceReqBo reqBo) {
    
        //入参校验
        this.validate(reqBo);
        
        UocUpdateCmpOrderBo uocUpdateCmpOrderBo = JSONObject.parseObject(JSON.toJSONString(reqBo), UocUpdateCmpOrderBo.class);
        int count = uocCmpOrderModel.updateCmpOrder(uocUpdateCmpOrderBo);
//        if(count == 0){
//            throw new ZTBusinessException("比选单更新数量为0");
//        }
        UocUpdateCmpOrderServiceRspBo rspBo = new UocUpdateCmpOrderServiceRspBo();
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBo;
    }
    private void validate(UocUpdateCmpOrderServiceReqBo reqBo){
        if (ObjectUtil.isEmpty(reqBo)){
            throw new ZTBusinessException("入参对象[UocDelCmpOrderServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getCmpOrderId())){
            throw new ZTBusinessException("入参比选单ID不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getCmpOrderNo())){
            throw new ZTBusinessException("入参比选单编号不能为空");
        }
        UocCmpOrderQryBo uocCmpOrderQryBo = new UocCmpOrderQryBo();
        uocCmpOrderQryBo.setCmpOrderId(reqBo.getCmpOrderId());
        uocCmpOrderQryBo.setCmpOrderNo(reqBo.getCmpOrderNo());
        uocCmpOrderQryBo = uocCmpOrderModel.qryCmpOrder(uocCmpOrderQryBo);
        if (ObjectUtil.isEmpty(uocCmpOrderQryBo.getCreateTime())){
            throw new ZTBusinessException("传入的比选单id不存在");
        }
    }
}
