package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题：UocQryAfOrderListServiceImpl
 * 描述：售后服务的列表查询接口实现类
 */
@HTServiceImpl
public class UocQryAfOrderListServiceImpl implements UocQryAfOrderListService {

    /**
     * 售后单模型层
     */
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    @Override
    public UocQryAfOrderListRspBO qryAfOrderList(UocQryAfOrderListReqBO reqBo) {
        //定义出参对象
        UocQryAfOrderListRspBO rspBO = new UocQryAfOrderListRspBO();

        //入参转换
        UocAfOrderQryBo uocAfOrderQryBo = UocRu.js(reqBo, UocAfOrderQryBo.class);

        //调用售后单模型层，查询售后单列表
        List<UocAfOrder> uocAfOrderList = this.iUocAfOrderModel.getAfOrderList(uocAfOrderQryBo);

        if (CollectionUtils.isEmpty(uocAfOrderList)) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
            return rspBO;
        }

        //创建售后服务列表集合，参数转换
        List<UocQryAfOrderListBO> afOrderList = UocRu.jsl(uocAfOrderList, UocQryAfOrderListBO.class);

        //遍历封装售后单明细
        for (UocQryAfOrderListBO afOrder : afOrderList) {
            //定义售后单明细查询参数
            UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
            //设置售后单ID
            uocAfOrderItemQryBo.setAfOrderId(afOrder.getAfOrderId());

            //调用售后单明细模型层，查询售后单明细列表
            List<UocAfOrderItem> afOrderItemList = this.iUocAfOrderModel.getAfOrderItemList(uocAfOrderItemQryBo);

            //设置售后单明细列表
            afOrder.setAfOrderItemList(UocRu.jsl(afOrderItemList, UocQryAfOrderItemListBO.class));
        }

        //出参
        rspBO.setAfOrderList(afOrderList);
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
