package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocRejectDealInvoiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocRejectDealInvoiceRspBo;
import com.tydic.dyc.oc.transactionservice.UocRejectDealInvoiceTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：UocRejectDealInvoiceServiceImpl
 * 说明：驳回开票接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocRejectDealInvoiceServiceImpl implements UocRejectDealInvoiceService {

    /**
     * 索引配置
     */
    @Autowired
    private UocIndexConfig uocIndexConfig;

    /**
     * 统一线程池
     */
    @Autowired
    private UocThreadPool uocThreadPool;

    /**
     * 驳回开票事务层
     */
    @Autowired
    private UocRejectDealInvoiceTransaction uocRejectDealInvoiceTransaction;

    /**
     * 驳回开票
     */
    @Override
    public UocRejectDealInvoiceRspBo dealRejectDealInvoice(UocRejectDealInvoiceReqBo reqBo) {
        //调用驳回开票事务层，驳回开票
        UocRejectDealInvoiceRspBo rspBo = this.uocRejectDealInvoiceTransaction.dealRejectDealInvoice(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //调用同步ES
            this.syncEs(reqBo, rspBo);
        }

        //出参
        return rspBo;
    }

    /**
     * 同步ES
     */
    private void syncEs(UocRejectDealInvoiceReqBo reqBo, UocRejectDealInvoiceRspBo rspBo) {
        //定义数据同步BO集合
        List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<>();

        //定义数据同步BO
        SyncEsRunnableBo syncEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        //设置订单ID
        syncEsRunnableBo.setOrderId(rspBo.getOrderId());
        //设置对象ID
        syncEsRunnableBo.setObjId(rspBo.getSaleOrderId());
        //设置操作标识
        syncEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncEsRunnableBo);

        //调用统一线程池
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}
