package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfEffectiveQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfEffective;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderRspBo;
import com.tydic.dyc.oc.transactionservice.UocSaleShipOrderTransaction;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 描述: 〈领域服务-发货（基于销售单）实现〉
 *
 * @author : yuhao
 * @date : 2022/8/23 17:00
 */
@Slf4j
@HTServiceImpl
public class UocSaleShipOrderServiceImpl implements UocSaleShipOrderService {
    @Autowired
    private UocSaleShipOrderTransaction uocSaleShipOrderTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocSaleShipOrderRspBo dealImplShipOrder(UocSaleShipOrderReqBo reqBo) {
        UocSaleShipOrderRspBo rspBo = uocSaleShipOrderTransaction.dealImplShipOrder(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地 线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocSaleShipOrderReqBo reqBo, UocSaleShipOrderRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);

        SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
        shipBo.setIndexName(uocIndexConfig.getShipOrderIndex());
        shipBo.setOrderId(reqBo.getOrderId());
        shipBo.setObjId(rspBo.getShipOrderId());
        shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(shipBo);

        log.debug("发货单es同步：" + JSON.toJSONString(list));
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

