package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.*;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.SslClientUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description 分配接口
 * @author Luokan
 * @date 2024/12/03
 **/
@Slf4j
@HTServiceImpl
public class UocAllocationItemServiceImpl implements UocAllocationItemService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    /**
     * 商品池名称 企业采购 常量
     */
    private static final String POOL_NAME_SUPERMARKET = "supermarket";

    /**
     * 商品智能报价及同款信息查询接口地址
     */
    @Value("${uoc.intelligent.queryZdPriceInfo.url:/iio2/046564/tydicApi/queryZdPriceInfo}")
    private String queryZdPriceInfoUrl;

    @Override
    public UocAllocationItemRspBO dealAllocationItem(UocAllocationItemReqBO reqBO) {
        UocAllocationItemRspBO rsp = new UocAllocationItemRspBO();
        //查询所有的明细行，得到skuId集合
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemListByItemIds(reqBO.getSaleOrderItemIds());
        if (CollectionUtils.isEmpty(saleOrderItemList) || saleOrderItemList.size() != reqBO.getSaleOrderItemIds().size()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单明细信息错误！");
        }
        //获取智能报价及同款信息
        UocIntelligentZdPriceInfoRspBO intelligentZdPriceInfo = this.getIntelligentZdPriceInfo(saleOrderItemList.stream().map(UocSaleOrderItem::getSkuId).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(intelligentZdPriceInfo.getResult()) || saleOrderItemList.size() != intelligentZdPriceInfo.getResult().size()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "获取智能报价及同款信息错误！");
        }
        //Map<String, UocIntelligentZdPriceInfoBO> intelligentZdPriceMap = intelligentZdPriceInfo.getResult().stream().collect(Collectors.toMap(UocIntelligentZdPriceInfoBO::getSkuId, Function.identity()));
        Map<String, UocIntelligentZdPriceInfoBO> intelligentZdPriceMap = intelligentZdPriceInfo.getResult().stream()
                .collect(Collectors.toMap(
                        UocIntelligentZdPriceInfoBO::getSkuId,  // 键
                        Function.identity(),                    // 值
                        (existing, replacement) -> existing     // 冲突时保留第一个
                ));

        for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
            UocIntelligentZdPriceInfoBO uocIntelligentZdPriceInfoBO = intelligentZdPriceMap.get(saleOrderItem.getSkuId());
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            uocSaleOrderItem.setAllocationFlag(UocConstant.AllocationFlag.ALLOCATIONED);
            uocSaleOrderItem.setAllocationUserId(reqBO.getAllocationUserId());
            uocSaleOrderItem.setAllocationName(reqBO.getAllocationName());
            uocSaleOrderItem.setCheckFlag(UocConstant.CheckFlag.NO_CHECK);
            uocSaleOrderItem.setCheckUserId(reqBO.getCheckUserId());
            uocSaleOrderItem.setCheckName(reqBO.getCheckName());

            BigDecimal guidePrice = ObjectUtil.isNotEmpty(uocIntelligentZdPriceInfoBO.getGuidePrice()) ? new BigDecimal(uocIntelligentZdPriceInfoBO.getGuidePrice()).multiply(new BigDecimal("0.0001")) : new BigDecimal("0");
            uocSaleOrderItem.setGuidePrice(guidePrice.toPlainString());

            BigDecimal internetPrice = ObjectUtil.isNotEmpty(uocIntelligentZdPriceInfoBO.getInternetPrice()) ? new BigDecimal(uocIntelligentZdPriceInfoBO.getInternetPrice()).multiply(new BigDecimal("0.0001")) : new BigDecimal("0");
            uocSaleOrderItem.setInternetPrice(internetPrice.toPlainString());

            uocSaleOrderItem.setAllocationTime(new Date());
            this.iUocSaleOrderModel.updateSaleOrderItem(uocSaleOrderItem);
        }
        return rsp;
    }

    private UocIntelligentZdPriceInfoRspBO getIntelligentZdPriceInfo(List<String> skuIdList) {
        //定义出参对象
        UocIntelligentZdPriceInfoRspBO dycIntelligentZdPriceInfoRspBO = new UocIntelligentZdPriceInfoRspBO();

        try {
            //定义智能报价及同款信息查询业务数据对象
            UocIntelligentZdPriceInfoDataBO dycIntelligentZdPriceInfoDataBO = new UocIntelligentZdPriceInfoDataBO();
            //设置单品ID集合
            dycIntelligentZdPriceInfoDataBO.setSkuIdList(skuIdList);

            //定义智能报价及同款信息查询入参
            UocIntelligentZdPriceInfoReqBO dycIntelligentZdPriceInfoReqBO = new UocIntelligentZdPriceInfoReqBO();
            //设置校验流水
            dycIntelligentZdPriceInfoReqBO.setSerialNo(String.valueOf(IdUtil.nextId()));
            //设置商品池名称
            dycIntelligentZdPriceInfoReqBO.setPoolName(POOL_NAME_SUPERMARKET);
            //设置业务数据
            dycIntelligentZdPriceInfoReqBO.setData(dycIntelligentZdPriceInfoDataBO);

            log.info("订单分配接口|获取智能报价及同款信息|调用智能化平台入参: {}", JSON.toJSONString(dycIntelligentZdPriceInfoReqBO));
            //HTTP请求调用
            String httpRspStr = SslClientUtil.doPost(queryZdPriceInfoUrl, JSON.toJSONString(dycIntelligentZdPriceInfoReqBO));
            log.info("订单分配接口|获取智能报价及同款信息|调用智能化平台出参: {}", httpRspStr);

            //获取HTTP请求调用返回结果，出参转换
            dycIntelligentZdPriceInfoRspBO = JSON.parseObject(httpRspStr, UocIntelligentZdPriceInfoRspBO.class);

            if (!UocRspConstants.RSP_CODE_SUCCESS.equals(dycIntelligentZdPriceInfoRspBO.getRespCode())) {
                log.error("订单分配接口|获取智能报价及同款信息|调用智能化平台失败: {}", dycIntelligentZdPriceInfoRspBO.getRspDesc());
            }

        } catch (Exception e) {
            log.error("订单分配接口|获取智能报价及同款信息|调用智能化平台异常: {}", e.getMessage());
            throw new ZTBusinessException("订单分配接口|获取智能报价及同款信息|调用智能化平台异常: " + e.getMessage());
        }

        return dycIntelligentZdPriceInfoRspBO;
    }
}
